/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant.fresh;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.types.Environment;
import org.hibernate.tool.ant.fresh.HibernateToolTask;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;
import org.hibernate.tool.api.metadata.MetadataDescriptor;

public class ExportCfgTask {
    HibernateToolTask parent = null;
    Properties properties = new Properties();

    public ExportCfgTask(HibernateToolTask parent) {
        this.parent = parent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setDestinationFolder(File destinationFolder) {
        this.properties.put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", destinationFolder);
    }

    public void setMetadataDescriptor(MetadataDescriptor metadataDescriptor) {
        this.properties.put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", metadataDescriptor);
    }

    public void setTemplatePath(Path path) {
        this.properties.put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", path);
    }

    public void addConfiguredProperty(Environment.Variable variable) {
        this.properties.put(variable.getKey(), variable.getValue());
    }

    public void execute() {
        Exporter exporter = ExporterFactory.createExporter((ExporterType)ExporterType.CFG);
        MetadataDescriptor metadataDescriptor = (MetadataDescriptor)this.properties.get("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor");
        exporter.getProperties().putAll((Map<?, ?>)metadataDescriptor.getProperties());
        exporter.getProperties().putAll((Map<?, ?>)this.properties);
        exporter.start();
    }
}

