/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.time.Duration;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.pojo.logging.impl.MassIndexingLog;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingType;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingTypeGroupMonitor;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingTypeGroupMonitorContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingTypeGroupMonitorCreateContext;

public class PojoMassIndexingLoggingMonitor
implements MassIndexingMonitor {
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final AtomicReference<StatusMessageInfo> lastMessageInfo = new AtomicReference();
    private final LongAdder totalCounter = new LongAdder();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;
    private boolean countOnStart;
    private boolean countOnBeforeType;
    private final AtomicLong typesToIndex = new AtomicLong();
    private final AtomicLong groupsWithUnknownTotal = new AtomicLong();

    public PojoMassIndexingLoggingMonitor() {
        this(50);
    }

    public PojoMassIndexingLoggingMonitor(int logAfterNumberOfDocuments) {
        this(logAfterNumberOfDocuments, false, true);
    }

    public PojoMassIndexingLoggingMonitor(boolean countOnStart, boolean countOnBeforeType) {
        this(50, countOnStart, countOnBeforeType);
    }

    public PojoMassIndexingLoggingMonitor(int logAfterNumberOfDocuments, boolean countOnStart, boolean countOnBeforeType) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
        this.countOnStart = countOnStart;
        this.countOnBeforeType = countOnBeforeType;
    }

    @Override
    public MassIndexingTypeGroupMonitor typeGroupMonitor(MassIndexingTypeGroupMonitorCreateContext context) {
        this.typesToIndex.addAndGet(context.includedTypes().size());
        return new MassIndexingTypeGroupMonitorImpl(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentsAdded(long increment) {
        if (this.startTime == 0L) {
            PojoMassIndexingLoggingMonitor pojoMassIndexingLoggingMonitor = this;
            synchronized (pojoMassIndexingLoggingMonitor) {
                if (this.startTime == 0L) {
                    long theStartTime = System.nanoTime();
                    this.lastMessageInfo.set(new StatusMessageInfo(this.startTime, 0L));
                    this.startTime = theStartTime;
                }
            }
        }
        long previous = this.documentsDoneCounter.getAndAdd(increment);
        long current = previous + increment;
        int period = this.getStatusMessagePeriod();
        if (previous / (long)period < current / (long)period) {
            long currentTime = System.nanoTime();
            this.printStatusMessage(this.startTime, currentTime, this.totalCounter.longValue(), current, this.typesToIndex.get(), this.groupsWithUnknownTotal.get() != 0L);
        }
    }

    @Override
    public void documentsBuilt(long number) {
    }

    @Override
    public void entitiesLoaded(long size) {
    }

    @Override
    public void indexingCompleted() {
        MassIndexingLog.INSTANCE.indexingEntitiesCompleted(this.documentsDoneCounter.longValue(), this.totalCounter.longValue(), Duration.ofNanos(System.nanoTime() - this.startTime));
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long currentTime, long totalTodoCount, long doneCount, long typesToIndex, boolean remainingUnknown) {
        StatusMessageInfo currentStatusMessageInfo = new StatusMessageInfo(currentTime, doneCount);
        StatusMessageInfo previousStatusMessageInfo = this.lastMessageInfo.getAndAccumulate(currentStatusMessageInfo, StatusMessageInfo.UPDATE_IF_MORE_UP_TO_DATE_FUNCTION);
        if (!currentStatusMessageInfo.isMoreUpToDateThan(previousStatusMessageInfo)) {
            return;
        }
        long elapsedNano = currentTime - startTime;
        long intervalBetweenLogsNano = currentStatusMessageInfo.currentTime - previousStatusMessageInfo.currentTime;
        float estimateSpeed = (float)doneCount * 1.0E9f / (float)elapsedNano;
        float currentSpeed = (float)(currentStatusMessageInfo.documentsDone - previousStatusMessageInfo.documentsDone) * 1.0E9f / (float)intervalBetweenLogsNano;
        if (remainingUnknown) {
            if (typesToIndex > 0L) {
                MassIndexingLog.INSTANCE.indexingProgress(doneCount, typesToIndex, currentSpeed, estimateSpeed);
            } else {
                MassIndexingLog.INSTANCE.indexingProgress(doneCount, currentSpeed, estimateSpeed);
            }
        } else {
            float estimatePercentileComplete = (float)doneCount * 100.0f / (float)totalTodoCount;
            long remainingCount = totalTodoCount - doneCount;
            if (typesToIndex > 0L) {
                MassIndexingLog.INSTANCE.indexingProgress(estimatePercentileComplete, doneCount, totalTodoCount, currentSpeed, estimateSpeed, remainingCount, typesToIndex);
            } else {
                MassIndexingLog.INSTANCE.indexingProgressWithRemainingTime(estimatePercentileComplete, doneCount, totalTodoCount, currentSpeed, estimateSpeed, remainingCount, Duration.ofMillis((long)((float)remainingCount / currentSpeed * 1000.0f)));
            }
        }
    }

    private class MassIndexingTypeGroupMonitorImpl
    implements MassIndexingTypeGroupMonitor {
        private final long numberOfTypes;
        private final OptionalLong totalBefore;
        private boolean totalUnknown = true;

        public MassIndexingTypeGroupMonitorImpl(MassIndexingTypeGroupMonitorCreateContext context) {
            this.numberOfTypes = context.includedTypes().size();
            if (PojoMassIndexingLoggingMonitor.this.countOnStart) {
                this.totalBefore = context.totalCount();
                if (this.totalBefore.isPresent()) {
                    this.totalUnknown = false;
                    long count = this.totalBefore.getAsLong();
                    PojoMassIndexingLoggingMonitor.this.totalCounter.add(count);
                    MassIndexingLog.INSTANCE.indexingEntitiesApprox(count, context.includedTypes().stream().map(MassIndexingType::entityName).collect(Collectors.joining(", ", "[ ", " ]")));
                }
            } else {
                this.totalBefore = OptionalLong.empty();
            }
        }

        @Override
        public void documentsIndexed(long increment) {
            if (this.totalUnknown) {
                PojoMassIndexingLoggingMonitor.this.totalCounter.add(increment);
            }
        }

        @Override
        public void indexingStarted(MassIndexingTypeGroupMonitorContext context) {
            PojoMassIndexingLoggingMonitor.this.typesToIndex.addAndGet(-this.numberOfTypes);
            if (PojoMassIndexingLoggingMonitor.this.countOnBeforeType) {
                OptionalLong totalCount = context.totalCount();
                if (totalCount.isEmpty()) {
                    PojoMassIndexingLoggingMonitor.this.groupsWithUnknownTotal.incrementAndGet();
                } else {
                    this.totalUnknown = false;
                    long actual = totalCount.getAsLong();
                    PojoMassIndexingLoggingMonitor.this.totalCounter.add(actual - this.totalBefore.orElse(0L));
                    MassIndexingLog.INSTANCE.indexingEntities(actual);
                }
            }
        }

        @Override
        public void indexingCompleted(MassIndexingTypeGroupMonitorContext context) {
            if (this.totalUnknown) {
                PojoMassIndexingLoggingMonitor.this.groupsWithUnknownTotal.decrementAndGet();
            }
        }
    }

    private static class StatusMessageInfo {
        public static final BinaryOperator<StatusMessageInfo> UPDATE_IF_MORE_UP_TO_DATE_FUNCTION = (storedVal, newVal) -> newVal.isMoreUpToDateThan((StatusMessageInfo)storedVal) ? newVal : storedVal;
        public final long currentTime;
        public final long documentsDone;

        public StatusMessageInfo(long currentTime, long documentsDone) {
            this.currentTime = currentTime;
            this.documentsDone = documentsDone;
        }

        public boolean isMoreUpToDateThan(StatusMessageInfo other) {
            return this.documentsDone > other.documentsDone || this.documentsDone == other.documentsDone && this.currentTime > other.currentTime;
        }
    }
}

