/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultBigIntegerIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultBooleanIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultByteIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultCharacterIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultCharacterValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultDoubleIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultDurationValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultEnumValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultFloatIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultIntegerIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURIValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaNetURLValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlDateValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimeValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimestampValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilCalendarValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaUtilDateValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultLongIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultPeriodValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultShortIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultStringIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultUUIDIdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultUUIDValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneIdValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZoneOffsetValueBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.PassThroughValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgesConfigurationContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.DefaultBinderDefinitionStep;
import org.hibernate.search.mapper.pojo.bridge.mapping.DefaultBridgeDefinitionStep;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.StaticIdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.StaticValueBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class BridgeResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<PojoRawTypeIdentifier<?>, IdentifierBinder> exactRawTypeIdentifierBridgeMappings;
    private final Map<PojoRawTypeIdentifier<?>, ValueBinder> exactRawTypeValueBridgeMappings;
    private final List<TypePatternBinderMapping<IdentifierBinder>> typePatternIdentifierBridgeMappings;
    private final List<TypePatternBinderMapping<ValueBinder>> typePatternValueBridgeMappings;

    private BridgeResolver(Builder builder) {
        this.exactRawTypeIdentifierBridgeMappings = new HashMap(builder.exactRawTypeIdentifierBridgeMappings);
        this.exactRawTypeValueBridgeMappings = new HashMap(builder.exactRawTypeValueBridgeMappings);
        this.typePatternIdentifierBridgeMappings = new ArrayList<TypePatternBinderMapping<IdentifierBinder>>(builder.typePatternIdentifierBridgeMappings);
        this.typePatternValueBridgeMappings = new ArrayList<TypePatternBinderMapping<ValueBinder>>(builder.typePatternValueBridgeMappings);
        Collections.reverse(this.typePatternIdentifierBridgeMappings);
        Collections.reverse(this.typePatternValueBridgeMappings);
    }

    public IdentifierBinder resolveIdentifierBinderForType(PojoGenericTypeModel<?> sourceType) {
        IdentifierBinder result = BridgeResolver.getBinderOrNull(sourceType, this.exactRawTypeIdentifierBridgeMappings, this.typePatternIdentifierBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultIdentifierBridgeFromSourceType(sourceType);
        }
        return result;
    }

    public ValueBinder resolveValueBinderForType(PojoGenericTypeModel<?> sourceType) {
        ValueBinder result = BridgeResolver.getBinderOrNull(sourceType, this.exactRawTypeValueBridgeMappings, this.typePatternValueBridgeMappings);
        if (result == null) {
            throw log.unableToResolveDefaultValueBridgeFromSourceType(sourceType);
        }
        return result;
    }

    private static <B> B getBinderOrNull(PojoGenericTypeModel<?> sourceType, Map<PojoRawTypeIdentifier<?>, B> exactRawTypeBridgeMappings, List<TypePatternBinderMapping<B>> typePatternBinderMappings) {
        PojoRawTypeIdentifier rawType = sourceType.rawType().typeIdentifier();
        B result = exactRawTypeBridgeMappings.get(rawType);
        if (result == null) {
            Iterator<TypePatternBinderMapping<B>> mappingIterator = typePatternBinderMappings.iterator();
            while (result == null && mappingIterator.hasNext()) {
                result = mappingIterator.next().getBinderIfMatching(sourceType);
            }
        }
        return result;
    }

    public static class Builder
    implements BridgesConfigurationContext {
        private final PojoBootstrapIntrospector introspector;
        private final TypePatternMatcherFactory typePatternMatcherFactory;
        private final Map<PojoRawTypeIdentifier<?>, IdentifierBinder> exactRawTypeIdentifierBridgeMappings = new HashMap();
        private final Map<PojoRawTypeIdentifier<?>, ValueBinder> exactRawTypeValueBridgeMappings = new HashMap();
        private final List<TypePatternBinderMapping<IdentifierBinder>> typePatternIdentifierBridgeMappings = new ArrayList<TypePatternBinderMapping<IdentifierBinder>>();
        private final List<TypePatternBinderMapping<ValueBinder>> typePatternValueBridgeMappings = new ArrayList<TypePatternBinderMapping<ValueBinder>>();

        public Builder(PojoBootstrapIntrospector introspector, TypePatternMatcherFactory typePatternMatcherFactory) {
            this.introspector = introspector;
            this.typePatternMatcherFactory = typePatternMatcherFactory;
            this.addDefaults();
        }

        @Override
        public <T> DefaultBridgeDefinitionStep<?, T> exactType(Class<T> clazz) {
            return new ExactTypeDefaultBridgeDefinitionStep(this.introspector.typeModel(clazz).typeIdentifier());
        }

        @Override
        public <T> DefaultBinderDefinitionStep<?> subTypesOf(Class<T> clazz) {
            TypePatternMatcher subTypesMatcher = this.typePatternMatcherFactory.createRawSuperTypeMatcher(clazz);
            return new TypePatternDefaultBinderDefinitionStep(subTypesMatcher);
        }

        @Override
        public <T> DefaultBinderDefinitionStep<?> strictSubTypesOf(Class<T> clazz) {
            TypePatternMatcher strictSubTypesMatcher = this.typePatternMatcherFactory.createRawSuperTypeMatcher(clazz).and(this.typePatternMatcherFactory.createExactRawTypeMatcher(clazz).negate());
            return new TypePatternDefaultBinderDefinitionStep(strictSubTypesMatcher);
        }

        public BridgeResolver build() {
            return new BridgeResolver(this);
        }

        private void addDefaults() {
            ((DefaultBridgeDefinitionStep)this.exactType(String.class).valueBinder(new PassThroughValueBridge.Binder<String>(String.class, ParseUtils::parseString))).identifierBridge(new DefaultStringIdentifierBridge());
            this.exactType(Character.class).valueBridge(new DefaultCharacterValueBridge()).identifierBridge(new DefaultCharacterIdentifierBridge());
            ((DefaultBridgeDefinitionStep)this.exactType(Boolean.class).valueBinder(new PassThroughValueBridge.Binder<Boolean>(Boolean.class, ConvertUtils::convertBoolean))).identifierBridge(new DefaultBooleanIdentifierBridge());
            ((DefaultBridgeDefinitionStep)this.exactType(Byte.class).valueBinder(new PassThroughValueBridge.Binder<Byte>(Byte.class, ConvertUtils::convertByte))).identifierBridge(new DefaultByteIdentifierBridge());
            ((DefaultBridgeDefinitionStep)this.exactType(Short.class).valueBinder(new PassThroughValueBridge.Binder<Short>(Short.class, ConvertUtils::convertShort))).identifierBridge(new DefaultShortIdentifierBridge());
            ((DefaultBridgeDefinitionStep)this.exactType(Integer.class).valueBinder(new PassThroughValueBridge.Binder<Integer>(Integer.class, ConvertUtils::convertInteger))).identifierBridge(new DefaultIntegerIdentifierBridge());
            ((DefaultBridgeDefinitionStep)this.exactType(Long.class).valueBinder(new PassThroughValueBridge.Binder<Long>(Long.class, ConvertUtils::convertLong))).identifierBridge(new DefaultLongIdentifierBridge());
            ((DefaultBridgeDefinitionStep)this.exactType(Float.class).valueBinder(new PassThroughValueBridge.Binder<Float>(Float.class, ConvertUtils::convertFloat))).identifierBridge(new DefaultFloatIdentifierBridge());
            ((DefaultBridgeDefinitionStep)this.exactType(Double.class).valueBinder(new PassThroughValueBridge.Binder<Double>(Double.class, ConvertUtils::convertDouble))).identifierBridge(new DefaultDoubleIdentifierBridge());
            this.strictSubTypesOf(Enum.class).valueBinder(new DefaultEnumValueBridge.Binder()).identifierBinder(new DefaultEnumIdentifierBridge.Binder());
            ((DefaultBridgeDefinitionStep)this.exactType(BigInteger.class).valueBinder(new PassThroughValueBridge.Binder<BigInteger>(BigInteger.class, ConvertUtils::convertBigInteger))).identifierBridge(new DefaultBigIntegerIdentifierBridge());
            this.exactType(BigDecimal.class).valueBinder(new PassThroughValueBridge.Binder<BigDecimal>(BigDecimal.class, ConvertUtils::convertBigDecimal));
            this.exactType(LocalDate.class).valueBinder(new PassThroughValueBridge.Binder<LocalDate>(LocalDate.class, ParseUtils::parseLocalDate));
            this.exactType(Instant.class).valueBinder(new PassThroughValueBridge.Binder<Instant>(Instant.class, ParseUtils::parseInstant));
            this.exactType(LocalDateTime.class).valueBinder(new PassThroughValueBridge.Binder<LocalDateTime>(LocalDateTime.class, ParseUtils::parseLocalDateTime));
            this.exactType(LocalTime.class).valueBinder(new PassThroughValueBridge.Binder<LocalTime>(LocalTime.class, ParseUtils::parseLocalTime));
            this.exactType(ZonedDateTime.class).valueBinder(new PassThroughValueBridge.Binder<ZonedDateTime>(ZonedDateTime.class, ParseUtils::parseZonedDateTime));
            this.exactType(Year.class).valueBinder(new PassThroughValueBridge.Binder<Year>(Year.class, ParseUtils::parseYear));
            this.exactType(YearMonth.class).valueBinder(new PassThroughValueBridge.Binder<YearMonth>(YearMonth.class, ParseUtils::parseYearMonth));
            this.exactType(MonthDay.class).valueBinder(new PassThroughValueBridge.Binder<MonthDay>(MonthDay.class, ParseUtils::parseMonthDay));
            this.exactType(OffsetDateTime.class).valueBinder(new PassThroughValueBridge.Binder<OffsetDateTime>(OffsetDateTime.class, ParseUtils::parseOffsetDateTime));
            this.exactType(OffsetTime.class).valueBinder(new PassThroughValueBridge.Binder<OffsetTime>(OffsetTime.class, ParseUtils::parseOffsetTime));
            this.exactType(ZoneOffset.class).valueBridge(new DefaultZoneOffsetValueBridge());
            this.exactType(ZoneId.class).valueBridge(new DefaultZoneIdValueBridge());
            this.exactType(ZoneId.class).valueBridge(new DefaultZoneIdValueBridge());
            this.exactType(Period.class).valueBridge(new DefaultPeriodValueBridge());
            this.exactType(Duration.class).valueBridge(new DefaultDurationValueBridge());
            this.exactType(UUID.class).valueBridge(new DefaultUUIDValueBridge()).identifierBridge(new DefaultUUIDIdentifierBridge());
            this.exactType(java.util.Date.class).valueBridge(new DefaultJavaUtilDateValueBridge());
            this.exactType(Calendar.class).valueBridge(new DefaultJavaUtilCalendarValueBridge());
            this.exactType(Date.class).valueBridge(new DefaultJavaSqlDateValueBridge());
            this.exactType(Timestamp.class).valueBridge(new DefaultJavaSqlTimestampValueBridge());
            this.exactType(Time.class).valueBridge(new DefaultJavaSqlTimeValueBridge());
            this.exactType(URI.class).valueBridge(new DefaultJavaNetURIValueBridge());
            this.exactType(URL.class).valueBridge(new DefaultJavaNetURLValueBridge());
            this.subTypesOf(GeoPoint.class).valueBinder(new PassThroughValueBridge.Binder<GeoPoint>(GeoPoint.class, ParseUtils::parseGeoPoint));
        }

        private class ExactTypeDefaultBridgeDefinitionStep<T>
        implements DefaultBridgeDefinitionStep<ExactTypeDefaultBridgeDefinitionStep<T>, T> {
            private final PojoRawTypeIdentifier<T> typeIdentifier;

            private ExactTypeDefaultBridgeDefinitionStep(PojoRawTypeIdentifier<T> typeIdentifier) {
                this.typeIdentifier = typeIdentifier;
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> identifierBinder(IdentifierBinder binder) {
                Builder.this.exactRawTypeIdentifierBridgeMappings.put(this.typeIdentifier, binder);
                return this;
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> valueBinder(ValueBinder binder) {
                Builder.this.exactRawTypeValueBridgeMappings.put(this.typeIdentifier, binder);
                return this;
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> identifierBridge(IdentifierBridge<T> bridge) {
                return this.identifierBinder(new StaticIdentifierBinder<T>(this.typeIdentifier.javaClass(), bridge));
            }

            @Override
            public ExactTypeDefaultBridgeDefinitionStep<T> valueBridge(ValueBridge<T, ?> bridge) {
                return this.valueBinder(new StaticValueBinder<T>(this.typeIdentifier.javaClass(), bridge));
            }
        }

        private class TypePatternDefaultBinderDefinitionStep
        implements DefaultBinderDefinitionStep<TypePatternDefaultBinderDefinitionStep> {
            private final TypePatternMatcher typePatternMatcher;

            private TypePatternDefaultBinderDefinitionStep(TypePatternMatcher typePatternMatcher) {
                this.typePatternMatcher = typePatternMatcher;
            }

            @Override
            public TypePatternDefaultBinderDefinitionStep identifierBinder(IdentifierBinder binder) {
                Builder.this.typePatternIdentifierBridgeMappings.add(new TypePatternBinderMapping<IdentifierBinder>(this.typePatternMatcher, binder));
                return this;
            }

            @Override
            public TypePatternDefaultBinderDefinitionStep valueBinder(ValueBinder binder) {
                Builder.this.typePatternValueBridgeMappings.add(new TypePatternBinderMapping<ValueBinder>(this.typePatternMatcher, binder));
                return this;
            }
        }
    }

    private static final class TypePatternBinderMapping<B> {
        private final TypePatternMatcher matcher;
        private final B binder;

        TypePatternBinderMapping(TypePatternMatcher matcher, B binder) {
            this.matcher = matcher;
            this.binder = binder;
        }

        B getBinderIfMatching(PojoGenericTypeModel<?> typeModel) {
            if (this.matcher.matches(typeModel)) {
                return this.binder;
            }
            return null;
        }
    }
}

