/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Suppressed;

@CategorizedLogger(category="org.hibernate.search", description="The root category for any Hibernate Search logs.\nIt may also include logs that do not fit any other, more specific, logging category.\n")
@MessageLogger(projectCode="HSEARCH")
public interface EngineMiscLog {
    public static final String CATEGORY_NAME = "org.hibernate.search";
    public static final EngineMiscLog INSTANCE = (EngineMiscLog)LoggerFactory.make(EngineMiscLog.class, (String)"org.hibernate.search", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=242, value="Invalid type '%1$s': missing constructor. The type must expose a public, no-arguments constructor.")
    public SearchException noPublicNoArgConstructor(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=519, value="Hibernate Search encountered %3$s failures during %1$s. Only the first %2$s failures are displayed here. See the TRACE logs for extra failures.")
    public String collectedFailureLimitReached(String var1, int var2, int var3);

    @Message(id=520, value="Hibernate Search encountered failures during %1$s. Failures:\n%2$s")
    public SearchException collectedFailures(String var1, String var2, @Suppressed Collection<Throwable> var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=521, value="Hibernate Search encountered a failure during %1$s; continuing for now to list all problems, but the process will ultimately be aborted.\n%2$s\nFailure:")
    public void newCollectedFailure(String var1, @FormatWith(value=EventContextFormatter.class) EventContextProvider var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=522, value="Exception while collecting a failure -- this may indicate a bug or a missing test in Hibernate Search. Please report it: https://hibernate.org/community/ Nested exception: %1$s")
    public void exceptionWhileCollectingFailure(String var1, @Cause Throwable var2);

    @Message(id=525, value="Invalid call of ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.")
    public SearchException cannotCallDslExtensionIfSupportedAfterOrElse();

    @Message(id=526, value="None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).")
    public SearchException dslExtensionNoMatch(List<?> var1);

    @Message(id=530, value="Unable to load class '%1$s': %2$s")
    public ClassLoadingException unableToLoadTheClass(String var1, String var2, @Cause Throwable var3);

    @Message(id=540, value="Unable to instantiate class '%1$s': %2$s")
    public SearchException unableToInstantiateClass(String var1, String var2, @Cause Exception var3);

    @Message(id=542, value="Invalid type '%1$s': this type cannot be assigned to type '%2$s'.")
    public SearchException subtypeExpected(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=543, value="Invalid type '%1$s': this type is an interface. An implementation class is required.")
    public SearchException implementationRequired(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=544, value="Invalid type '%1$s': missing constructor. The type must expose a public constructor with a single parameter of type Map.")
    public SearchException noPublicMapArgConstructor(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=569, value="The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.")
    public void failureInFailureHandler(@Cause Throwable var1);

    @Message(id=576, value="Ambiguous bean reference to type '%1$s': multiple beans are explicitly defined for this type in Hibernate Search's internal registry. Explicitly defined beans: %2$s.")
    public BeanNotFoundException multipleConfiguredBeanReferencesForType(@FormatWith(value=ClassFormatter.class) Class<?> var1, List<? extends BeanReference<?>> var2);

    @Message(id=577, value="No beans defined for type '%1$s' in Hibernate Search's internal registry.")
    public BeanNotFoundException noConfiguredBeanReferenceForType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=578, value="No beans defined for type '%1$s' and name '%2$s' in Hibernate Search's internal registry.")
    public BeanNotFoundException noConfiguredBeanReferenceForTypeAndName(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=579, value="Unable to resolve bean reference to type '%1$s' and name '%2$s'. %3$s")
    public BeanNotFoundException cannotResolveBeanReference(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3, @Cause RuntimeException var4, @Suppressed Collection<? extends RuntimeException> var5);

    @Message(id=580, value="Unable to resolve bean reference to type '%1$s'. %2$s")
    public BeanNotFoundException cannotResolveBeanReference(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause RuntimeException var3, @Suppressed Collection<? extends RuntimeException> var4);

    @Message(value="Failed to resolve bean from Hibernate Search's internal registry with exception: %1$s")
    public String failedToResolveBeanUsingInternalRegistry(String var1);

    @Message(value="Failed to resolve bean from bean manager with exception: %1$s")
    public String failedToResolveBeanUsingBeanManager(String var1);

    @Message(value="Failed to resolve bean using reflection with exception: %1$s")
    public String failedToResolveBeanUsingReflection(String var1);

    @Message(id=589, value="Unable to create bean using reflection: %1$s")
    public BeanNotFoundException unableToCreateBeanUsingReflection(String var1, @Cause Exception var2);

    @Message(id=590, value="No configured bean manager.")
    public BeanNotFoundException noConfiguredBeanManager();

    @Message(id=591, value="Unable to resolve '%2$s' to a class extending '%1$s': %3$s")
    public BeanNotFoundException unableToResolveToClassName(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, String var3, @Cause Exception var4);

    @Message(id=592, value="Invalid bean reference: '%1$s'. The reference is prefixed with '%2$s', which is not a valid bean retrieval prefix. If you want to reference a bean by name, and the name contains a colon, use 'bean:%1$s'. Otherwise, use a valid bean retrieval prefix among the following: %3$s.")
    public BeanNotFoundException invalidBeanRetrieval(String var1, String var2, List<String> var3, @Cause Exception var4);

    @Message(id=612, value="Unable to close saved value for key %1$s: %2$s")
    public SearchException unableToCloseSavedValue(String var1, String var2, @Cause Exception var3);

    @Message(id=613, value="Unable to access the Search integration: initialization hasn't completed yet.")
    public SearchException noIntegrationBecauseInitializationNotComplete();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=628, value="Work discarded, thread was interrupted while waiting for space to schedule: %1$s")
    public void interruptedWorkError(Runnable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=629, value="%1$s")
    public void exceptionOccurred(String var1, @Cause Throwable var2);
}

