// $Id: GetDeclaredMethods.java 19566 2010-05-20 11:58:01Z hardy.ferentschik $
/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat, Inc. and/or its affiliates, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.validator.util.privilegedactions;

import java.security.PrivilegedAction;
import java.lang.reflect.Method;

/**
 * @author Emmanuel Bernard
 */
public class GetDeclaredMethods implements PrivilegedAction<Method[]> {
	private final Class<?> clazz;

	public static GetDeclaredMethods action(Class<?> clazz) {
		return new GetDeclaredMethods( clazz );
	}

	private GetDeclaredMethods(Class<?> clazz) {
		this.clazz = clazz;
	}

	public Method[] run() {
		return clazz.getDeclaredMethods();
	}
}
