/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.Changeset;

public final class ChangesetList
implements Iterable<LuceneWork> {
    private final Iterable<Changeset> changesets;

    public ChangesetList(Iterable<Changeset> changesets) {
        this.changesets = changesets;
    }

    void markProcessed() {
        for (Changeset changeset : this.changesets) {
            changeset.markProcessed();
        }
    }

    @Override
    public Iterator<LuceneWork> iterator() {
        return new WorkIterator(this.changesets.iterator());
    }

    List<LuceneWork> copyToList() {
        LinkedList<LuceneWork> list = new LinkedList<LuceneWork>();
        for (LuceneWork lw : this) {
            list.add(lw);
        }
        return list;
    }

    private static class WorkIterator
    implements Iterator<LuceneWork> {
        private Iterator<Changeset> outerIterator;
        private Iterator<LuceneWork> current = Collections.emptyList().iterator();

        public WorkIterator(Iterator<Changeset> iterator) {
            this.outerIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext() && this.outerIterator.hasNext()) {
                this.current = this.outerIterator.next().getWorkListIterator();
            }
            return this.current.hasNext() || this.outerIterator.hasNext();
        }

        @Override
        public LuceneWork next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Reached the end of the ChangesetList. Make sure to guard .next() with .hasNext()");
            }
            return this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator is unable to remove elements");
        }
    }
}

