/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.Rectangle;

public abstract class SpatialHelper {
    private static final double LOG2 = Math.log(2.0);

    private SpatialHelper() {
    }

    public static int getCellIndex(double coordinate, double range, int quadTreeLevel) {
        return (int)Math.floor(Math.pow(2.0, quadTreeLevel) * coordinate / range);
    }

    public static String getQuadTreeCellId(Point point, int quadTreeLevel) {
        double[] indexablesCoordinates = SpatialHelper.projectToIndexSpace(point);
        int longitudeCellIndex = SpatialHelper.getCellIndex(indexablesCoordinates[0], Math.PI * 2, quadTreeLevel);
        int latitudeCellIndex = SpatialHelper.getCellIndex(indexablesCoordinates[1], Math.PI, quadTreeLevel);
        return SpatialHelper.formatQuadTreeCellId(longitudeCellIndex, latitudeCellIndex);
    }

    public static List<String> getQuadTreeCellsIds(Point lowerLeft, Point upperRight, int quadTreeLevel) {
        double[] projectedLowerLeft = SpatialHelper.projectToIndexSpace(lowerLeft);
        int lowerLeftXIndex = SpatialHelper.getCellIndex(projectedLowerLeft[0], Math.PI * 2, quadTreeLevel);
        int lowerLeftYIndex = SpatialHelper.getCellIndex(projectedLowerLeft[1], Math.PI, quadTreeLevel);
        double[] projectedUpperRight = SpatialHelper.projectToIndexSpace(upperRight);
        int upperRightXIndex = SpatialHelper.getCellIndex(projectedUpperRight[0], Math.PI * 2, quadTreeLevel);
        int upperRightYIndex = SpatialHelper.getCellIndex(projectedUpperRight[1], Math.PI, quadTreeLevel);
        double[] projectedLowerRight = SpatialHelper.projectToIndexSpace(Point.fromDegrees(lowerLeft.getLatitude(), upperRight.getLongitude()));
        int lowerRightXIndex = SpatialHelper.getCellIndex(projectedLowerRight[0], Math.PI * 2, quadTreeLevel);
        int lowerRightYIndex = SpatialHelper.getCellIndex(projectedLowerRight[1], Math.PI, quadTreeLevel);
        double[] projectedUpperLeft = SpatialHelper.projectToIndexSpace(Point.fromDegrees(upperRight.getLatitude(), lowerLeft.getLongitude()));
        int upperLeftXIndex = SpatialHelper.getCellIndex(projectedUpperLeft[0], Math.PI * 2, quadTreeLevel);
        int upperLeftYIndex = SpatialHelper.getCellIndex(projectedUpperLeft[1], Math.PI, quadTreeLevel);
        int startX = Math.min(Math.min(Math.min(lowerLeftXIndex, upperLeftXIndex), upperRightXIndex), lowerRightXIndex);
        int endX = Math.max(Math.max(Math.max(lowerLeftXIndex, upperLeftXIndex), upperRightXIndex), lowerRightXIndex);
        int startY = Math.min(Math.min(Math.min(lowerLeftYIndex, upperLeftYIndex), upperRightYIndex), lowerRightYIndex);
        int endY = Math.max(Math.max(Math.max(lowerLeftYIndex, upperLeftYIndex), upperRightYIndex), lowerRightYIndex);
        ArrayList<String> quadTreeCellsIds = new ArrayList<String>((endX + 1 - startX) * (endY + 1 - startY));
        for (int xIndex = startX; xIndex <= endX; ++xIndex) {
            for (int yIndex = startY; yIndex <= endY; ++yIndex) {
                quadTreeCellsIds.add(SpatialHelper.formatQuadTreeCellId(xIndex, yIndex));
            }
        }
        return quadTreeCellsIds;
    }

    public static List<String> getQuadTreeCellsIds(Coordinates center, double radius, int quadTreeLevel) {
        Rectangle boundingBox = Rectangle.fromBoundingCircle(center, radius);
        double lowerLeftLatitude = boundingBox.getLowerLeft().getLatitude();
        double lowerLeftLongitude = boundingBox.getLowerLeft().getLongitude();
        double upperRightLatitude = boundingBox.getUpperRight().getLatitude();
        double upperRightLongitude = boundingBox.getUpperRight().getLongitude();
        if (upperRightLongitude < lowerLeftLongitude) {
            List<String> quadTreeCellsIds = SpatialHelper.getQuadTreeCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, lowerLeftLongitude), Point.fromDegreesInclusive(upperRightLatitude, 180.0), quadTreeLevel);
            quadTreeCellsIds.addAll(SpatialHelper.getQuadTreeCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, 180.0), Point.fromDegreesInclusive(upperRightLatitude, upperRightLongitude), quadTreeLevel));
            return quadTreeCellsIds;
        }
        return SpatialHelper.getQuadTreeCellsIds(Point.fromDegreesInclusive(lowerLeftLatitude, lowerLeftLongitude), Point.fromDegreesInclusive(upperRightLatitude, upperRightLongitude), quadTreeLevel);
    }

    public static int findBestQuadTreeLevelForSearchRange(double searchRange) {
        double iterations = 40075.017 / (2.0 * searchRange);
        return (int)Math.max(0.0, Math.ceil(Math.log(iterations) / LOG2));
    }

    public static double[] projectToIndexSpace(Point point) {
        double[] projectedCoordinates = new double[]{point.getLongitudeRad() * Math.cos(point.getLatitudeRad()), point.getLatitudeRad()};
        return projectedCoordinates;
    }

    public static String formatFieldName(int quadTreeLevel, String fieldName) {
        return fieldName + "_HSSI_" + quadTreeLevel;
    }

    public static String formatLatitude(String fieldName) {
        return fieldName + "_HSSI_Latitude";
    }

    public static String formatLongitude(String fieldName) {
        return fieldName + "_HSSI_Longitude";
    }

    public static String formatQuadTreeCellId(int xIndex, int yIndex) {
        return xIndex + "|" + yIndex;
    }
}

