/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.ejb.event.BeanCallback;
import org.hibernate.ejb.event.Callback;
import org.hibernate.ejb.event.ListenerCallback;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.source.binder.JpaCallbackClass;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.logging.Logger;

public final class CallbackResolver {
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)CallbackResolver.class.getName());
    private static boolean useAnnotationAnnotatedByListener = false;

    private CallbackResolver() {
    }

    public static Callback[] resolveCallback(XClass beanClass, Class annotation, ReflectionManager reflectionManager) {
        List defaultListeners;
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ArrayList<Class> orderedListeners = new ArrayList<Class>();
        XClass currentClazz = beanClass;
        boolean stopListeners = false;
        boolean stopDefaultListeners = false;
        do {
            BeanCallback callback = null;
            List methods = currentClazz.getDeclaredMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                Method method;
                String methodName;
                XMethod xMethod = (XMethod)methods.get(i);
                if (!xMethod.isAnnotationPresent(annotation) || callbacksMethodNames.contains(methodName = (method = reflectionManager.toMethod(xMethod)).getName())) continue;
                if (callback == null) {
                    callback = new BeanCallback(method);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 0) {
                        throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + annotation.getName() + " - " + xMethod);
                    }
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    LOG.debugf("Adding %s as %s callback for entity %s", methodName, annotation.getSimpleName(), beanClass.getName());
                    callbacks.add(0, callback);
                    callbacksMethodNames.add(0, methodName);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName());
            }
            if (!stopListeners) {
                CallbackResolver.getListeners(currentClazz, orderedListeners);
                stopListeners = currentClazz.isAnnotationPresent(ExcludeSuperclassListeners.class);
                stopDefaultListeners = currentClazz.isAnnotationPresent(ExcludeDefaultListeners.class);
            }
            while ((currentClazz = currentClazz.getSuperclass()) != null && !currentClazz.isAnnotationPresent(Entity.class) && !currentClazz.isAnnotationPresent(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        if (!stopDefaultListeners && (defaultListeners = (List)reflectionManager.getDefaults().get(EntityListeners.class)) != null) {
            int defaultListenerSize = defaultListeners.size();
            for (int i = defaultListenerSize - 1; i >= 0; --i) {
                orderedListeners.add((Class)defaultListeners.get(i));
            }
        }
        for (Class listener : orderedListeners) {
            ListenerCallback callback = null;
            if (listener == null) continue;
            XClass xListener = reflectionManager.toXClass(listener);
            callbacksMethodNames = new ArrayList();
            List methods = xListener.getDeclaredMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                Method method;
                String methodName;
                XMethod xMethod = (XMethod)methods.get(i);
                if (!xMethod.isAnnotationPresent(annotation) || callbacksMethodNames.contains(methodName = (method = reflectionManager.toMethod(xMethod)).getName())) continue;
                if (callback == null) {
                    try {
                        callback = new ListenerCallback(method, listener.newInstance());
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistenceException("Unable to create instance of " + listener.getName() + " as a listener of beanClass", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new PersistenceException("Unable to create instance of " + listener.getName() + " as a listener of beanClass", (Throwable)e);
                    }
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 1) {
                        throw new PersistenceException("Callback methods annotated in a listener bean class must return void and take one argument: " + annotation.getName() + " - " + method);
                    }
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    LOG.debugf("Adding %s as %s callback for entity %s", methodName, annotation.getSimpleName(), beanClass.getName());
                    callbacks.add(0, callback);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName() + " and callback listener: " + listener.getName());
            }
        }
        return callbacks.toArray(new Callback[callbacks.size()]);
    }

    public static Callback[] resolveCallbacks(Class<?> entityClass, Class<?> callbackClass, ClassLoaderService classLoaderService, EntityBinding binding) {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        for (JpaCallbackClass jpaCallbackClass : binding.getJpaCallbackClasses()) {
            Class listener = classLoaderService.classForName(jpaCallbackClass.getName());
            String methodName = jpaCallbackClass.getCallbackMethod(callbackClass);
            Callback callback = jpaCallbackClass.isListener() ? CallbackResolver.createListenerCallback(entityClass, callbackClass, listener, methodName) : CallbackResolver.createBeanCallback(callbackClass, methodName);
            LOG.debugf("Adding %s as %s callback for entity %s", methodName, callbackClass.getName(), entityClass.getName());
            assert (callback != null);
            callbacks.add(callback);
        }
        return callbacks.toArray(new Callback[callbacks.size()]);
    }

    private static Callback createListenerCallback(Class<?> entityClass, Class<?> callbackClass, Object listener, String methodName) {
        Callback callback;
        Class<?> callbackSuperclass = callbackClass.getSuperclass();
        if (callbackSuperclass != null && (callback = CallbackResolver.createListenerCallback(entityClass, callbackSuperclass, listener, methodName)) != null) {
            return callback;
        }
        for (Method method : callbackClass.getDeclaredMethods()) {
            Class<?> argType;
            Class<?>[] argTypes;
            if (!method.getName().equals(methodName) || (argTypes = method.getParameterTypes()).length != 1 || (argType = argTypes[0]) != Object.class && argType != entityClass) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return new ListenerCallback(method, listener);
        }
        return null;
    }

    private static Callback createBeanCallback(Class<?> callbackClass, String methodName) {
        Callback callback;
        Class<?> callbackSuperclass = callbackClass.getSuperclass();
        if (callbackSuperclass != null && (callback = CallbackResolver.createBeanCallback(callbackSuperclass, methodName)) != null) {
            return callback;
        }
        for (Method method : callbackClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 0) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return new BeanCallback(method);
        }
        return null;
    }

    private static void getListeners(XClass currentClazz, List<Class> orderedListeners) {
        EntityListeners entityListeners = (EntityListeners)currentClazz.getAnnotation(EntityListeners.class);
        if (entityListeners != null) {
            Class[] classes = entityListeners.value();
            int size = classes.length;
            for (int index = size - 1; index >= 0; --index) {
                orderedListeners.add(classes[index]);
            }
        }
        if (useAnnotationAnnotatedByListener) {
            Annotation[] annotations;
            for (Annotation annot : annotations = currentClazz.getAnnotations()) {
                entityListeners = annot.getClass().getAnnotation(EntityListeners.class);
                if (entityListeners == null) continue;
                Class[] classes = entityListeners.value();
                int size = classes.length;
                for (int index = size - 1; index >= 0; --index) {
                    orderedListeners.add(classes[index]);
                }
            }
        }
    }

    static {
        Target target = EntityListeners.class.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType type : target.value()) {
                if (!type.equals((Object)ElementType.ANNOTATION_TYPE)) continue;
                useAnnotationAnnotatedByListener = true;
            }
        }
    }
}

