/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.grails.maven.plugin.AbstractGrailsMojo;
import org.grails.maven.plugin.tools.GrailsProject;

public class MvnValidateMojo
extends AbstractGrailsMojo {
    private String artifactId;
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        GrailsProject grailsProject;
        try {
            grailsProject = this.getGrailsServices().readProjectDescriptor();
        }
        catch (MojoExecutionException e) {
            this.getLog().info((CharSequence)"No Grails application found - skipping validation.");
            return;
        }
        if (!this.artifactId.equals(grailsProject.getAppName())) {
            throw new MojoFailureException("app.name [" + grailsProject.getAppName() + "] in " + "application.properties is different of the artifactId [" + this.artifactId + "] in the pom.xml");
        }
        if (grailsProject.getAppVersion() == null) {
            grailsProject.setAppVersion("1.0-SNAPSHOT");
            this.getLog().warn((CharSequence)"application.properties didn't contain an app.version property");
            this.getLog().warn((CharSequence)("Setting to default value '" + grailsProject.getAppVersion() + "'."));
            this.getGrailsServices().writeProjectDescriptor(this.getBasedir(), grailsProject);
        }
        String pomVersion = this.version.trim();
        String grailsVersion = grailsProject.getAppVersion().trim();
        if (!grailsVersion.equals(pomVersion)) {
            throw new MojoFailureException("app.version [" + grailsVersion + "] in " + "application.properties is different of the version [" + pomVersion + "] in the pom.xml");
        }
    }
}

