/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.grails.maven.plugin.AbstractGrailsMojo;

public class GrailsPackagePluginMojo
extends AbstractGrailsMojo {
    private Artifact artifact;
    protected ArtifactHandler artifactHandler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.runGrails("PackagePlugin");
        String zipFileName = this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip";
        if (!zipFileName.startsWith("grails-")) {
            zipFileName = "grails-" + zipFileName;
        }
        File zipGeneratedByGrails = new File(this.getBasedir(), zipFileName);
        File mavenZipFile = new File(this.project.getBuild().getDirectory(), zipFileName);
        mavenZipFile.delete();
        if (!zipGeneratedByGrails.renameTo(mavenZipFile)) {
            throw new MojoExecutionException("Unable to copy the plugin ZIP to the target directory");
        }
        this.getLog().info((CharSequence)("Moved plugin ZIP to '" + mavenZipFile + "'."));
        this.artifact.setFile(mavenZipFile);
        this.artifact.setArtifactHandler(this.artifactHandler);
    }
}

