/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.grails.maven.plugin.tools.GrailsProject;
import org.grails.maven.plugin.tools.GrailsServices;

public class CreatePomMojo
extends AbstractMojo {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
    private String groupId;
    private File basedir;
    protected GrailsServices grailsServices;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.grailsServices.setBasedir(this.basedir);
        GrailsProject grailsDescr = this.grailsServices.readProjectDescriptor();
        HashMap<String, String> varSubstitutions = new HashMap<String, String>();
        varSubstitutions.put("groupId", this.groupId);
        varSubstitutions.put("artifactId", grailsDescr.getAppName());
        varSubstitutions.put("version", grailsDescr.getAppVersion());
        InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("archetype-resources/pom.xml");
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            writer = new BufferedWriter(new FileWriter(new File(this.basedir, "pom.xml")));
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = VAR_PATTERN.matcher(line);
                StringBuffer buf = new StringBuffer(line.length());
                while (matcher.find()) {
                    String sub = (String)varSubstitutions.get(matcher.group(1));
                    if (sub == null) {
                        sub = Matcher.quoteReplacement(matcher.group());
                    }
                    matcher.appendReplacement(buf, sub);
                }
                matcher.appendTail(buf);
                writer.write(buf.toString());
                writer.newLine();
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create POM file.", (Exception)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        File webXml = new File(this.basedir, "src/main/webapp/WEB-INF/web.xml");
        if (!webXml.exists()) {
            webXml.getParentFile().mkdirs();
            try {
                webXml.createNewFile();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to create the dummy web descriptor '" + webXml.getPath() + "' - " + "the package phase won't work without it, so you should create " + "it (an empty file) manually. Reason: " + e.getMessage()));
            }
        }
    }
}

