/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import grails.util.Metadata;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.groovy.grails.cli.support.GrailsBuildHelper;
import org.codehaus.groovy.grails.cli.support.GrailsRootLoader;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.grails.maven.plugin.tools.GrailsServices;

public abstract class AbstractGrailsMojo
extends AbstractMojo {
    public static final String PLUGIN_PREFIX = "grails-";
    protected File basedir;
    protected String env;
    protected boolean nonInteractive;
    protected File pluginsDir;
    protected MavenProject project;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private MavenProjectBuilder projectBuilder;
    private GrailsServices grailsServices;
    private OutputStream infoOutputStream = new OutputStream(){
        StringBuffer buffer = new StringBuffer();

        public void write(int b) throws IOException {
            if (b == 10) {
                AbstractGrailsMojo.this.getLog().info((CharSequence)this.buffer.toString());
                this.buffer.setLength(0);
            } else {
                this.buffer.append((char)b);
            }
        }
    };
    private OutputStream warnOutputStream = new OutputStream(){
        StringBuffer buffer = new StringBuffer();

        public void write(int b) throws IOException {
            if (b == 10) {
                AbstractGrailsMojo.this.getLog().warn((CharSequence)this.buffer.toString());
                this.buffer.setLength(0);
            } else {
                this.buffer.append((char)b);
            }
        }
    };

    protected File getBasedir() {
        if (this.basedir == null) {
            throw new RuntimeException("Your subclass have a field called 'basedir'. Remove it and use getBasedir() instead.");
        }
        return this.basedir;
    }

    protected GrailsServices getGrailsServices() throws MojoExecutionException {
        this.grailsServices.setBasedir(this.basedir);
        return this.grailsServices;
    }

    protected void runGrails(String targetName) throws MojoExecutionException {
        this.runGrails(targetName, null, false);
    }

    protected void runGrails(String targetName, String args, boolean includeProjectDeps) throws MojoExecutionException {
        Set deps = this.getGrailsPluginDependencies();
        ArrayList<String> systemDeps = new ArrayList<String>();
        try {
            Iterator dependancies = this.project.getDependencies().iterator();
            while (dependancies.hasNext()) {
                Dependency dep = (Dependency)dependancies.next();
                if (!dep.getScope().equals("system")) continue;
                systemDeps.add(dep.getSystemPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (includeProjectDeps) {
            deps.addAll(this.project.getRuntimeArtifacts());
        }
        try {
            int retval;
            URL[] classpath = new URL[deps.size() + systemDeps.size() + 1];
            int index = 0;
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                classpath[index++] = ((Artifact)iter.next()).getFile().toURI().toURL();
            }
            iter = systemDeps.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                if (!path.endsWith(".jar")) {
                    path = path.substring(0, path.lastIndexOf("/"));
                }
                classpath[index++] = new File(path).toURI().toURL();
            }
            String javaHome = System.getProperty("java.home");
            File toolsJar = new File(javaHome, "../lib/tools.jar");
            if (!toolsJar.exists()) {
                toolsJar = new File(javaHome, "tools.jar");
            }
            classpath[classpath.length - 1] = toolsJar.toURI().toURL();
            GrailsRootLoader rootLoader = new GrailsRootLoader(classpath, ClassLoader.getSystemClassLoader());
            GrailsBuildHelper helper = new GrailsBuildHelper((ClassLoader)rootLoader, null, this.basedir.getAbsolutePath());
            this.configureBuildSettings(helper);
            Metadata metadata = Metadata.getInstance((File)new File(this.getBasedir(), "application.properties"));
            boolean metadataModified = false;
            Iterator iter2 = deps.iterator();
            while (iter2.hasNext()) {
                Artifact dep = (Artifact)iter2.next();
                if (dep.getType() == null || !dep.getType().equals("grails-plugin") && !dep.getType().equals("zip")) continue;
                metadataModified |= this.installGrailsPlugin(dep, metadata, helper);
            }
            if (metadataModified) {
                metadata.persist();
            }
            if (this.nonInteractive) {
                String string = args = args == null ? "--non-interactive" : "--non-interactive " + args;
            }
            if ((retval = helper.execute(targetName, args, this.env)) != 0) {
                throw new MojoExecutionException("Grails returned non-zero value: " + retval);
            }
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to start Grails", ex);
        }
    }

    private Set getGrailsPluginDependencies() throws MojoExecutionException {
        Iterator iter;
        Artifact pluginArtifact = this.findArtifact(this.project.getPluginArtifacts(), "org.grails", "grails-maven-plugin");
        MavenProject project = null;
        try {
            project = this.projectBuilder.buildFromRepository(pluginArtifact, this.remoteRepositories, this.localRepository);
        }
        catch (ProjectBuildingException ex) {
            throw new MojoExecutionException("Failed to get information about Grails Maven Plugin", (Exception)((Object)ex));
        }
        Dependency firstDep = null;
        Iterator iter2 = this.project.getDependencies().iterator();
        while (iter2.hasNext()) {
            Dependency d = (Dependency)iter2.next();
            if (!"org.grails".equals(d.getGroupId())) continue;
            firstDep = d;
            break;
        }
        ArrayList<Dependency> pluginDeps = project.getDependencies();
        if (firstDep != null) {
            String grailsVersion = firstDep.getVersion();
            this.getLog().info((CharSequence)("Using Grails " + grailsVersion));
            ArrayList<Dependency> grailsDeps = new ArrayList<Dependency>();
            iter = pluginDeps.iterator();
            while (iter.hasNext()) {
                Dependency d = (Dependency)iter.next();
                if (!"org.grails".equals(d.getGroupId()) || "grails-maven-archetype".equals(d.getArtifactId())) continue;
                d.setVersion(grailsVersion);
                grailsDeps.add(d);
            }
            pluginDeps = grailsDeps;
        }
        List deps = this.artifactsByGroupId(this.dependenciesToArtifacts(pluginDeps), "org.grails");
        HashSet pluginDependencies = new HashSet();
        iter = deps.iterator();
        while (iter.hasNext()) {
            pluginDependencies.addAll(this.getPluginDependencies((Artifact)iter.next()));
        }
        return pluginDependencies;
    }

    private void configureBuildSettings(GrailsBuildHelper helper) throws ClassNotFoundException, IllegalAccessException, InstantiationException, MojoExecutionException, NoSuchMethodException, InvocationTargetException {
        String targetDir = this.project.getBuild().getDirectory();
        helper.setDependenciesExternallyConfigured(true);
        helper.setCompileDependencies(this.artifactsToFiles(this.project.getCompileArtifacts()));
        helper.setTestDependencies(this.artifactsToFiles(this.project.getTestArtifacts()));
        helper.setRuntimeDependencies(this.artifactsToFiles(this.project.getRuntimeArtifacts()));
        helper.setProjectWorkDir(new File(targetDir));
        helper.setClassesDir(new File(targetDir, "classes"));
        helper.setTestClassesDir(new File(targetDir, "test-classes"));
        helper.setResourcesDir(new File(targetDir, "resources"));
        helper.setProjectPluginsDir(this.pluginsDir);
    }

    private Set getPluginDependencies(Artifact pom) throws MojoExecutionException {
        try {
            MavenProject project = this.projectBuilder.buildFromRepository(pom, this.remoteRepositories, this.localRepository);
            List dependencies = project.getDependencies();
            Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)dependencies, null, null, null);
            ArtifactResolutionResult result = this.artifactCollector.collect(dependencyArtifacts, project.getArtifact(), this.localRepository, this.remoteRepositories, this.artifactMetadataSource, null, Collections.EMPTY_LIST);
            dependencyArtifacts.addAll(result.getArtifacts());
            dependencyArtifacts.add(project.getArtifact());
            Iterator iter = dependencyArtifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            }
            return dependencyArtifacts;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", ex);
        }
    }

    private boolean installGrailsPlugin(Artifact plugin, Metadata metadata, GrailsBuildHelper helper) throws IOException, ArchiverException {
        String pluginName = plugin.getArtifactId();
        String pluginVersion = plugin.getVersion();
        if (pluginName.startsWith(PLUGIN_PREFIX)) {
            pluginName = pluginName.substring(PLUGIN_PREFIX.length());
        }
        this.getLog().info((CharSequence)("Installing plugin " + pluginName + ":" + pluginVersion));
        File targetDir = new File(helper.getProjectPluginsDir(), pluginName + "-" + pluginVersion);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
            ZipUnArchiver unzipper = new ZipUnArchiver();
            unzipper.enableLogging((Logger)new ConsoleLogger(3, "zip-unarchiver"));
            unzipper.setSourceFile(plugin.getFile());
            unzipper.setDestDirectory(targetDir);
            unzipper.setOverwrite(true);
            unzipper.extract();
            this.getLog().debug((CharSequence)"Updating project metadata");
            metadata.setProperty("plugins." + pluginName, pluginVersion);
            return true;
        }
        return false;
    }

    private List artifactsToFiles(Collection artifacts) {
        ArrayList<File> files = new ArrayList<File>(artifacts.size());
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            files.add(((Artifact)iter.next()).getFile());
        }
        return files;
    }

    private Artifact findArtifact(Collection artifacts, String groupId, String artifactId) {
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact;
        }
        return null;
    }

    private List artifactsByGroupId(Collection artifacts, String groupId) {
        ArrayList<Artifact> inGroup = new ArrayList<Artifact>(artifacts.size());
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!artifact.getGroupId().equals(groupId)) continue;
            inGroup.add(artifact);
        }
        return inGroup;
    }

    private List dependenciesToArtifacts(Collection deps) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(deps.size());
        Iterator iter = deps.iterator();
        while (iter.hasNext()) {
            artifacts.add(this.dependencyToArtifact((Dependency)iter.next()));
        }
        return artifacts;
    }

    private Artifact dependencyToArtifact(Dependency dep) {
        return this.artifactFactory.createBuildArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), "pom");
    }
}

