/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.nfi.NFIParserException;

final class Lexer {
    private final CharSequence source;
    private int position;
    private Token curToken;
    private int curTokenStart;
    private int curTokenEnd;
    private int mark;
    private Token nextToken;
    private int nextTokenStart;

    Lexer(CharSequence source) {
        this.source = source;
        this.position = 0;
        this.lex();
    }

    public Token next() {
        this.lex();
        return this.curToken;
    }

    public Token peek() {
        return this.nextToken;
    }

    public String currentValue() {
        if (this.curTokenEnd > this.source.length()) {
            return "<EOF>";
        }
        int start = this.curTokenStart;
        int end = this.curTokenEnd;
        if (this.curToken == Token.STRING) {
            ++start;
            --end;
        }
        return this.source.subSequence(start, end).toString();
    }

    public String peekValue() {
        if (this.position > this.source.length()) {
            return "<EOF>";
        }
        return this.source.subSequence(this.nextTokenStart, this.position).toString();
    }

    public NFIParserException fail(String message) {
        throw new NFIParserException(message, this.curToken == Token.EOF);
    }

    public NFIParserException fail(String message, Object ... args) {
        throw this.fail(String.format(message, args));
    }

    public void mark() {
        this.mark = this.nextTokenStart;
    }

    public String markedValue() {
        int to = Math.min(this.curTokenEnd, this.source.length());
        return this.source.subSequence(this.mark, to).toString();
    }

    private boolean atEnd() {
        return this.position >= this.source.length();
    }

    private char ch() {
        if (this.atEnd()) {
            return '\u0000';
        }
        return this.source.charAt(this.position);
    }

    private void lex() {
        this.curToken = this.nextToken;
        this.curTokenStart = this.nextTokenStart;
        this.curTokenEnd = this.position;
        while (Character.isWhitespace(this.ch())) {
            ++this.position;
        }
        this.nextTokenStart = this.position;
        this.nextToken = this.getNextToken();
    }

    private static boolean isIdentStartChar(char c) {
        return Character.isAlphabetic(c) || c == '/' || c == '_';
    }

    private static boolean isIdentChar(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c) || c == '/' || c == '.' || c == '_';
    }

    private Token getNextToken() {
        if (Lexer.isIdentStartChar(this.ch())) {
            do {
                ++this.position;
            } while (Lexer.isIdentChar(this.ch()));
            return Token.IDENTIFIER;
        }
        char c = this.ch();
        ++this.position;
        switch (c) {
            case '\u0000': {
                return Token.EOF;
            }
            case '(': {
                return Token.OPENPAREN;
            }
            case ')': {
                return Token.CLOSEPAREN;
            }
            case '[': {
                return Token.OPENBRACKET;
            }
            case ']': {
                return Token.CLOSEBRACKET;
            }
            case '{': {
                return Token.OPENBRACE;
            }
            case '}': {
                return Token.CLOSEBRACE;
            }
            case ':': {
                return Token.COLON;
            }
            case ';': {
                return Token.SEMICOLON;
            }
            case ',': {
                return Token.COMMA;
            }
            case '|': {
                return Token.OR;
            }
            case '.': {
                if (this.ch() == '.') {
                    ++this.position;
                    if (this.ch() == '.') {
                        ++this.position;
                        return Token.ELLIPSIS;
                    }
                }
                return Token.INVALID;
            }
            case '\"': 
            case '\'': {
                while (!this.atEnd()) {
                    if (this.ch() == c) {
                        ++this.position;
                        return Token.STRING;
                    }
                    ++this.position;
                }
                return Token.INVALID;
            }
        }
        return Token.INVALID;
    }

    public static enum Token {
        OPENPAREN("("),
        CLOSEPAREN(")"),
        OPENBRACKET("["),
        CLOSEBRACKET("]"),
        OPENBRACE("{"),
        CLOSEBRACE("}"),
        SEMICOLON(";"),
        COLON(":"),
        COMMA(","),
        OR("|"),
        ELLIPSIS("..."),
        IDENTIFIER("identifier"),
        STRING("string"),
        INVALID(null),
        EOF("EOF");

        private final String name;

        private Token(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

