/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import org.geolatte.geom.crs.CrsRegistry;

public class CrsId {
    public static final String DEFAULT_AUTHORITY = "EPSG";
    public static final CrsId UNDEFINED = new CrsId("EPSG", -1);
    private final String authority;
    private final int code;

    public static CrsId parse(String srsString) {
        if (srsString == null || srsString.isEmpty()) {
            throw new IllegalArgumentException("Require input of form '<authority>:<code>");
        }
        String[] tokens = srsString.split(":");
        String codeStr = tokens[tokens.length - 1];
        int code = CrsId.toNumericIdentifier(codeStr);
        String authority = DEFAULT_AUTHORITY;
        if (tokens.length == 2) {
            authority = tokens[0];
        } else if (tokens.length == 7) {
            authority = tokens[4];
        }
        return CrsId.valueOf(authority, code);
    }

    private static int toNumericIdentifier(String codeStr) {
        codeStr = codeStr.trim();
        try {
            return Integer.valueOf(codeStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Can't parse value %s into an integer.", codeStr));
        }
    }

    public static CrsId valueOf(String authority, int code) {
        if (DEFAULT_AUTHORITY.equalsIgnoreCase(authority) && code <= 0) {
            return UNDEFINED;
        }
        CrsId result = null;
        if (DEFAULT_AUTHORITY.equalsIgnoreCase(authority)) {
            result = CrsRegistry.getCrsIdForEPSG(code);
        }
        return result == null ? new CrsId(authority, code) : result;
    }

    public static CrsId valueOf(int code) {
        return CrsId.valueOf(DEFAULT_AUTHORITY, code);
    }

    public CrsId(String authority, int code) {
        if (authority == null || authority.isEmpty()) {
            throw new IllegalArgumentException("Null or empty authority parameter.");
        }
        this.authority = authority.toUpperCase();
        this.code = code < 1 && DEFAULT_AUTHORITY.equals(this.authority) ? -1 : code;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("%S:%d", this.authority, this.code);
    }

    public String toUrn() {
        return String.format("urn:ogc:def:crs:%s::%s", this.authority, this.code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrsId crsId = (CrsId)o;
        if (this.code != crsId.code) {
            return false;
        }
        return this.authority.equals(crsId.authority);
    }

    public int hashCode() {
        int result = this.authority.hashCode();
        result = 31 * result + this.code;
        return result;
    }
}

