/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.Decoder;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.GeometryCollectionSdoDecoder;
import org.geolatte.geom.codec.db.oracle.LineStringSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiLineSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiPointSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiPolygonSdoDecoder;
import org.geolatte.geom.codec.db.oracle.PointSdoDecoder;
import org.geolatte.geom.codec.db.oracle.PolygonSdoDecoder;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;

public class Decoders {
    private static final List<AbstractSDODecoder> DECODERS = new ArrayList<AbstractSDODecoder>();

    public static Decoder decoderFor(SDOGeometry object) {
        for (Decoder decoder : DECODERS) {
            if (!decoder.accepts(object)) continue;
            return decoder;
        }
        throw new IllegalArgumentException("No decoder for type " + (Object)((Object)object.getGType().getTypeGeometry()));
    }

    public static Geometry decode(Struct raw) {
        SDOGeometry sdo = SDOGeometry.load(raw);
        return Decoders.decode(sdo);
    }

    public static Geometry decode(SDOGeometry sdo) {
        Decoder decoder = Decoders.decoderFor(sdo);
        return decoder.decode(sdo);
    }

    static {
        DECODERS.add(new PointSdoDecoder());
        DECODERS.add(new LineStringSdoDecoder());
        DECODERS.add(new PolygonSdoDecoder());
        DECODERS.add(new MultiLineSdoDecoder());
        DECODERS.add(new MultiPolygonSdoDecoder());
        DECODERS.add(new MultiPointSdoDecoder());
        DECODERS.add(new GeometryCollectionSdoDecoder());
    }
}

