/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.PostgisWkbEncoder;
import org.geolatte.geom.codec.WkbVisitor;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

class HANAWkbEncoder
extends PostgisWkbEncoder {
    HANAWkbEncoder() {
    }

    @Override
    protected <P extends Position> int calculateSize(Geometry<P> geom, boolean includeSrid) {
        int size = super.calculateSize(geom, includeSrid);
        return includeSrid && geom.getSRID() <= 0 ? size + 4 : size;
    }

    @Override
    protected <P extends Position> WkbVisitor<P> newWkbVisitor(ByteBuffer output, Geometry<P> geom) {
        return new HANAWkbVisitor(output);
    }

    private static class HANAWkbVisitor<P extends Position>
    extends WkbVisitor<P> {
        private boolean hasWrittenSrid = false;

        HANAWkbVisitor(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
            int typeCode = this.getGeometryType(geometry);
            CoordinateReferenceSystem<P> crs = geometry.getCoordinateReferenceSystem();
            if (!this.hasWrittenSrid) {
                typeCode |= 0x20000000;
            }
            if (CoordinateReferenceSystems.hasMeasureAxis(crs)) {
                typeCode |= 0x40000000;
            }
            if (CoordinateReferenceSystems.hasVerticalAxis(crs)) {
                typeCode |= Integer.MIN_VALUE;
            }
            output.putUInt(typeCode);
            if (!this.hasWrittenSrid) {
                int srid = geometry.getSRID();
                output.putInt(srid < 0 ? 0 : srid);
                this.hasWrittenSrid = true;
            }
        }
    }
}

