/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.Positions;

class PositionSequenceIterator<P extends Position>
implements Iterator<P> {
    private final PositionSequence<P> sequence;
    private int index = 0;

    PositionSequenceIterator(PositionSequence<P> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("Null sequence argument");
        }
        this.sequence = sequence;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.sequence.size();
    }

    @Override
    public P next() {
        double[] coordinates = new double[this.sequence.getCoordinateDimension()];
        if (this.hasNext()) {
            this.sequence.getCoordinates(this.index++, coordinates);
            return Positions.mkPosition(this.sequence.getPositionClass(), coordinates);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove method not supported on " + this.getClass().getName());
    }
}

