/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.Iterator;
import org.geolatte.geom.AbstractPositionSequence;
import org.geolatte.geom.LLAPositionVisitor;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.PositionSequenceIterator;
import org.geolatte.geom.PositionSequencePositionEquality;
import org.geolatte.geom.PositionVisitor;

class PackedPositionSequence<P extends Position>
extends AbstractPositionSequence<P> {
    private final double[] coordinates;

    PackedPositionSequence(PositionFactory<P> factory, double[] coordinates) {
        super(factory);
        this.coordinates = coordinates == null ? new double[0] : coordinates;
        if (this.coordinates.length % this.getCoordinateDimension() != 0) {
            throw new IllegalArgumentException(String.format("coordinate array size should be a multiple of %d. Current size = %d", this.getCoordinateDimension(), this.coordinates.length));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.length == 0;
    }

    @Override
    public void accept(PositionVisitor<P> visitor) {
        for (Position p : this) {
            visitor.visit(p);
        }
    }

    @Override
    public void accept(LLAPositionVisitor visitor) {
        double[] buffer = new double[this.getCoordinateDimension()];
        for (int i = 0; i < this.size(); ++i) {
            this.getCoordinates(i, buffer);
            visitor.visit(buffer);
        }
    }

    @Override
    public PositionSequence<P> reverse() {
        PositionSequenceBuilder<double[]> builder = PositionSequenceBuilders.fixedSized(this.size(), this.getPositionClass());
        double[] coords = new double[this.getCoordinateDimension()];
        for (int i = this.size() - 1; i >= 0; --i) {
            this.getCoordinates(i, coords);
            builder.add(coords);
        }
        return builder.toPositionSequence();
    }

    @Override
    public int size() {
        return this.coordinates.length / this.getCoordinateDimension();
    }

    @Override
    public Iterator<P> iterator() {
        return new PositionSequenceIterator(this);
    }

    @Override
    public PositionSequence<P> clone() {
        return new PackedPositionSequence(this.getPositionFactory(), Arrays.copyOf(this.coordinates, this.coordinates.length));
    }

    @Override
    public void setOrdinate(int index, int ordinateIndex, double value) {
        int dim = this.getCoordinateDimension();
        this.coordinates[index * dim + ordinateIndex] = value;
    }

    @Override
    public void getCoordinates(int position, double[] coordinates) {
        int dim = this.getCoordinateDimension();
        if (coordinates.length < dim) {
            throw new IllegalArgumentException("Position argument must be an array of size at least " + dim);
        }
        for (int i = 0; i < this.getCoordinateDimension(); ++i) {
            coordinates[i] = this.coordinates[position * dim + i];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        PackedPositionSequence that = (PackedPositionSequence)o;
        if (!this.getPositionClass().equals(that.getPositionClass())) {
            return false;
        }
        return new PositionSequencePositionEquality().equals(this, that);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.coordinates);
        result = 31 * result + this.getPositionClass().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                builder.append(" ,");
            }
            this.addCoordinate(i, builder);
        }
        builder.append("]");
        return builder.toString();
    }

    private void addCoordinate(int index, StringBuilder builder) {
        double[] c = new double[this.getCoordinateDimension()];
        this.getCoordinates(index, c);
        for (int i = 0; i < this.getCoordinateDimension(); ++i) {
            builder.append(c[i]).append(" ");
        }
    }
}

