/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.packager.rpm.RpmBaseTag;

public enum RpmSignatureTag implements RpmBaseTag
{
    PUBKEYS(266),
    DSAHEADER(267),
    RSAHEADER(268),
    SHA1HEADER(269),
    LONGARCHIVESIZE(271),
    SHA256HEADER(273),
    SIZE(1000),
    PGP(1002),
    MD5(1004),
    PAYLOAD_SIZE(1007),
    LONGSIZE(5009);

    private final Integer value;
    private static final Map<Integer, RpmSignatureTag> all;

    private RpmSignatureTag(Integer value) {
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static RpmSignatureTag find(Integer value) {
        return all.get(value);
    }

    static {
        all = new HashMap<Integer, RpmSignatureTag>(RpmSignatureTag.values().length);
        for (RpmSignatureTag tag : RpmSignatureTag.values()) {
            all.put(tag.getValue(), tag);
        }
    }
}

