/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.build;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.Normalizer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.packager.rpm.RpmLead;
import org.eclipse.packager.rpm.RpmSignatureTag;
import org.eclipse.packager.rpm.RpmTag;
import org.eclipse.packager.rpm.Rpms;
import org.eclipse.packager.rpm.build.LeadBuilder;
import org.eclipse.packager.rpm.build.PayloadProvider;
import org.eclipse.packager.rpm.header.Header;
import org.eclipse.packager.rpm.header.Headers;
import org.eclipse.packager.rpm.signature.SignatureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpmWriter
implements AutoCloseable {
    private static final OpenOption[] DEFAULT_OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final Logger logger = LoggerFactory.getLogger(RpmWriter.class);
    private final FileChannel file;
    private final RpmLead lead;
    private final ByteBuffer header;
    private boolean finished;
    private PayloadProvider payloadProvider;
    private final List<SignatureProcessor> signatureProcessors = new LinkedList<SignatureProcessor>();

    public RpmWriter(Path path, Supplier<RpmLead> leadProvider, Header<RpmTag> header, Charset headerCharset, OpenOption ... options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(leadProvider);
        Objects.requireNonNull(header);
        Objects.requireNonNull(headerCharset);
        this.file = FileChannel.open(path, options != null && options.length > 0 ? options : DEFAULT_OPEN_OPTIONS);
        this.lead = leadProvider.get();
        this.header = Headers.render(header.makeEntries(headerCharset), true, 63);
    }

    public RpmWriter(Path path, LeadBuilder leadBuilder, Header<RpmTag> header, OpenOption ... options) throws IOException {
        this(path, leadBuilder::build, header, StandardCharsets.UTF_8, options);
    }

    public RpmWriter(Path path, LeadBuilder leadBuilder, Header<RpmTag> header, Charset headerCharset, OpenOption ... options) throws IOException {
        this(path, leadBuilder::build, header, headerCharset, options);
    }

    public void addSignatureProcessor(SignatureProcessor processor) {
        this.signatureProcessors.add(processor);
    }

    public void addAllSignatureProcessors(List<SignatureProcessor> signatureProcessors) {
        this.signatureProcessors.addAll(signatureProcessors);
    }

    public void setPayload(PayloadProvider payloadProvider) throws IOException {
        this.checkNotFinished();
        Objects.requireNonNull(payloadProvider);
        this.payloadProvider = payloadProvider;
    }

    private void checkNotFinished() {
        if (this.finished) {
            throw new IllegalStateException("Writing of RPM is already finished");
        }
    }

    private static void debug(String fmt, Object ... args) {
        logger.debug(String.format(fmt, args));
    }

    private void writeLead() throws IOException {
        byte[] nameData;
        byte[] nameEncoded;
        ByteBuffer lead = ByteBuffer.allocate(Rpms.LEAD_MAGIC.length + 2 + 4 + 66 + 2 + 2 + 16);
        lead.put(Rpms.LEAD_MAGIC);
        lead.put(this.lead.getMajor());
        lead.put(this.lead.getMinor());
        lead.putShort(this.lead.getType());
        lead.putShort(this.lead.getArchitecture());
        String name = this.lead.getName();
        if (!Normalizer.isNormalized(name, Normalizer.Form.NFC)) {
            name = Normalizer.normalize(name, Normalizer.Form.NFC);
        }
        System.arraycopy(nameEncoded, 0, nameData, 0, (nameEncoded = name.getBytes(StandardCharsets.UTF_8)).length < (nameData = new byte[66]).length ? nameEncoded.length : nameData.length - 1);
        lead.put(nameData);
        lead.putShort(this.lead.getOperatingSystem());
        lead.putShort((short)this.lead.getSignatureVersion());
        lead.put(Rpms.EMPTY_128, 0, 16);
        lead.flip();
        this.safeWrite(lead);
    }

    private void safeWrite(ByteBuffer data) throws IOException {
        while (data.hasRemaining()) {
            this.file.write(data);
        }
    }

    private void writeSignatureHeader(Header<?> header) throws IOException {
        ByteBuffer buffer = Headers.render(header.makeEntries(), false, 62);
        int payloadSize = buffer.remaining();
        RpmWriter.debug("start header - offset: %s, len: %s", this.file.position(), payloadSize);
        this.safeWrite(buffer);
        int padding = Rpms.padding(payloadSize);
        if (padding > 0) {
            this.safeWrite(ByteBuffer.wrap(Rpms.EMPTY_128, 0, padding));
            RpmWriter.debug("write - padding - %s", padding);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.file.close();
        }
    }

    private void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.payloadProvider == null) {
            throw new IOException("Unable to finish RPM file, payload provider not set");
        }
        this.finished = true;
        int headerSize = this.header.remaining();
        long payloadSize = this.payloadProvider.getPayloadSize();
        RpmWriter.debug("data - %s - %s", headerSize, payloadSize);
        Header<RpmSignatureTag> signature = new Header<RpmSignatureTag>();
        this.processSignatures(signature);
        this.writeLead();
        this.writeSignatureHeader(signature);
        RpmWriter.debug("package - offset: %s", this.file.position());
        this.safeWrite(this.header.slice());
        RpmWriter.debug("payload - offset: %s", this.file.position());
        try (ReadableByteChannel payloadChannel = this.payloadProvider.openChannel();){
            if (payloadChannel instanceof FileChannel && !RpmWriter.isForceCopy()) {
                long count = RpmWriter.copyFileChannel((FileChannel)payloadChannel, this.file);
                RpmWriter.debug("transfered - %s", count);
            } else {
                long count = ByteStreams.copy((ReadableByteChannel)payloadChannel, (WritableByteChannel)this.file);
                RpmWriter.debug("copyied - %s", count);
            }
        }
        RpmWriter.debug("end - offset: %s", this.file.position());
    }

    private static boolean isForceCopy() {
        return Boolean.getBoolean("org.eclipse.packager.rpm.build.RpmWriter.forceCopy");
    }

    private static long copyFileChannel(FileChannel fileChannel, FileChannel file) throws IOException {
        long remaning;
        long rc;
        long position = 0L;
        for (remaning = fileChannel.size(); remaning > 0L; remaning -= rc) {
            rc = fileChannel.transferTo(position, remaning, file);
            if (rc < 0L) {
                throw new IOException(String.format("Failed to transfer bytes: rc = %s", rc));
            }
            RpmWriter.debug("transferTo - position: %s, size: %s => rc: %s", position, remaning, rc);
            if (rc == 0L) break;
            position += rc;
        }
        if (remaning > 0L) {
            throw new IOException("Failed to transfer full content");
        }
        return position;
    }

    private void processSignatures(Header<RpmSignatureTag> signature) throws IOException {
        for (SignatureProcessor processor : this.signatureProcessors) {
            processor.init(this.payloadProvider.getArchiveSize());
        }
        for (SignatureProcessor processor : this.signatureProcessors) {
            processor.feedHeader(this.header.slice());
        }
        try (ReadableByteChannel channel = this.payloadProvider.openChannel();){
            ByteBuffer buf = ByteBuffer.wrap(new byte[4096]);
            while (channel.read(buf) >= 0) {
                buf.flip();
                for (SignatureProcessor processor : this.signatureProcessors) {
                    processor.feedPayloadData(buf.slice());
                }
                buf.clear();
            }
        }
        for (SignatureProcessor processor : this.signatureProcessors) {
            processor.finish(signature);
        }
    }
}

