/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;

public class FilenameComparator
implements Comparator<File> {
    public static final FilenameComparator INSTANCE = new FilenameComparator();
    private Collator collator = Collator.getInstance();

    @Override
    public int compare(File o1, File o2) {
        if (o1.isFile()) {
            if (o2.isFile()) {
                CollationKey key1 = this.toKey(o1);
                CollationKey key2 = this.toKey(o2);
                return key1.compareTo(key2);
            }
            return -1;
        }
        if (o2.isDirectory()) {
            CollationKey key1 = this.toKey(o1);
            CollationKey key2 = this.toKey(o2);
            return key1.compareTo(key2);
        }
        return 1;
    }

    private CollationKey toKey(File f) {
        return this.collator.getCollationKey(f.getAbsolutePath());
    }
}

