/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    private final List<Connection.Listener> listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private final Callback _readCallback;
    private int _inputBufferSize = 2048;

    protected AbstractConnection(EndPoint endp, Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = endp;
        this._executor = executor;
        this._readCallback = new ReadCallback();
    }

    @Override
    public void addListener(Connection.Listener listener) {
        this.listeners.add(listener);
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this._inputBufferSize = inputBufferSize;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    @Deprecated
    public boolean isDispatchIO() {
        return false;
    }

    protected void failedCallback(final Callback callback, final Throwable x) {
        try {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        callback.failed(x);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOG.debug(e);
            callback.failed(x);
        }
    }

    public void fillInterested() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillInterested {}", this);
        }
        this.getEndPoint().fillInterested(this._readCallback);
    }

    public boolean isFillInterested() {
        return this.getEndPoint().isFillInterested();
    }

    public abstract void onFillable();

    protected void onFillInterestedFailed(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillInterestedFailed {}", this, cause);
        }
        if (this._endPoint.isOpen()) {
            boolean close = true;
            if (cause instanceof TimeoutException) {
                close = this.onReadTimeout();
            }
            if (close) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                } else {
                    this._endPoint.shutdownOutput();
                    this.fillInterested();
                }
            }
        }
    }

    protected boolean onReadTimeout() {
        return true;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", this);
        }
        for (Connection.Listener listener : this.listeners) {
            listener.onOpened(this);
        }
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", this);
        }
        for (Connection.Listener listener : this.listeners) {
            listener.onClosed(this);
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public int getMessagesIn() {
        return -1;
    }

    @Override
    public int getMessagesOut() {
        return -1;
    }

    @Override
    public long getBytesIn() {
        return -1L;
    }

    @Override
    public long getBytesOut() {
        return -1L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    private class ReadCallback
    implements Callback {
        private ReadCallback() {
        }

        @Override
        public void succeeded() {
            AbstractConnection.this.onFillable();
        }

        @Override
        public void failed(Throwable x) {
            AbstractConnection.this.onFillInterestedFailed(x);
        }

        public String toString() {
            return String.format("AC.ReadCB@%x{%s}", AbstractConnection.this.hashCode(), AbstractConnection.this);
        }
    }
}

