/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpGenerator {
    private static final Logger LOG = Log.getLogger(HttpGenerator.class);
    public static final ResponseInfo CONTINUE_100_INFO = new ResponseInfo(HttpVersion.HTTP_1_1, null, -1L, 100, null, false);
    public static final ResponseInfo PROGRESS_102_INFO = new ResponseInfo(HttpVersion.HTTP_1_1, null, -1L, 102, null, false);
    public static final ResponseInfo RESPONSE_500_INFO = new ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(){
        {
            this.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
        }
    }, 0L, 500, null, false);
    public static final int CHUNK_SIZE = 12;
    private State _state = State.START;
    private HttpTokens.EndOfContent _endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
    private long _contentPrepared = 0L;
    private boolean _noContent = false;
    private Boolean _persistent = null;
    private boolean _sendServerVersion;
    private boolean _needCRLF = false;
    private static final byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private static final byte[] CONTENT_LENGTH_0 = StringUtil.getBytes((String)"Content-Length: 0\r\n");
    private static final byte[] CONNECTION_KEEP_ALIVE = StringUtil.getBytes((String)"Connection: keep-alive\r\n");
    private static final byte[] CONNECTION_CLOSE = StringUtil.getBytes((String)"Connection: close\r\n");
    private static final byte[] CONNECTION_ = StringUtil.getBytes((String)"Connection: ");
    private static final byte[] HTTP_1_1_SPACE = StringUtil.getBytes((String)((Object)((Object)HttpVersion.HTTP_1_1) + " "));
    private static final byte[] CRLF = StringUtil.getBytes((String)"\r\n");
    private static final byte[] TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes((String)"Transfer-Encoding: chunked\r\n");
    private static byte[] SERVER = StringUtil.getBytes((String)"Server: Jetty(7.0.x)\r\n");
    private static final PreparedResponse[] __preprepared = new PreparedResponse[508];

    public static void setServerVersion(String version) {
        SERVER = StringUtil.getBytes((String)("Server: Jetty(" + version + ")\r\n"));
    }

    public void reset() {
        this._state = State.START;
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._noContent = false;
        this._persistent = null;
        this._contentPrepared = 0L;
        this._needCRLF = false;
        this._noContent = false;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public State getState() {
        return this._state;
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    public boolean isIdle() {
        return this._state == State.START;
    }

    public boolean isEnd() {
        return this._state == State.END;
    }

    public boolean isCommitted() {
        return this._state.ordinal() >= State.COMMITTED.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this._persistent);
    }

    public boolean isWritten() {
        return this._contentPrepared > 0L;
    }

    public long getContentPrepared() {
        return this._contentPrepared;
    }

    public void abort() {
        this._persistent = false;
        this._state = State.END;
        this._endOfContent = null;
    }

    public Result generateRequest(RequestInfo info, ByteBuffer header, ByteBuffer chunk, ByteBuffer content, boolean last) throws IOException {
        switch (this._state) {
            case START: {
                if (info == null) {
                    return Result.NEED_INFO;
                }
                if (header == null) {
                    return Result.NEED_HEADER;
                }
                if (this._persistent == null) {
                    this._persistent = info.getHttpVersion().ordinal() > HttpVersion.HTTP_1_0.ordinal();
                }
                int pos = BufferUtil.flipToFill((ByteBuffer)header);
                try {
                    this.generateRequestLine(info, header);
                    if (info.getHttpVersion() == HttpVersion.HTTP_0_9) {
                        this._noContent = true;
                    } else {
                        this.generateHeaders(info, header, content, last);
                    }
                    boolean expect100 = info.getHttpFields().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
                    if (expect100) {
                        this._state = State.COMMITTED;
                    } else {
                        int len = BufferUtil.length((ByteBuffer)content);
                        if (len > 0) {
                            this._contentPrepared += (long)len;
                            if (this.isChunking()) {
                                this.prepareChunk(header, len);
                            }
                        }
                        this._state = last ? State.COMPLETING : State.COMMITTED;
                    }
                    Result len = Result.FLUSH;
                    return len;
                }
                catch (Exception e) {
                    String message = e instanceof BufferOverflowException ? "Response header too large" : e.getMessage();
                    throw new IOException(message, e);
                }
                finally {
                    BufferUtil.flipToFlush((ByteBuffer)header, (int)pos);
                }
            }
            case COMMITTED: {
                int len = BufferUtil.length((ByteBuffer)content);
                if (len > 0) {
                    if (this.isChunking()) {
                        if (chunk == null) {
                            return Result.NEED_CHUNK;
                        }
                        BufferUtil.clearToFill((ByteBuffer)chunk);
                        this.prepareChunk(chunk, len);
                        BufferUtil.flipToFlush((ByteBuffer)chunk, (int)0);
                    }
                    this._contentPrepared += (long)len;
                }
                if (last) {
                    this._state = State.COMPLETING;
                    return len > 0 ? Result.FLUSH : Result.CONTINUE;
                }
                return Result.FLUSH;
            }
            case COMPLETING: {
                if (BufferUtil.hasContent((ByteBuffer)content)) {
                    LOG.debug("discarding content in COMPLETING", new Object[0]);
                    BufferUtil.clear((ByteBuffer)content);
                }
                if (this.isChunking()) {
                    if (chunk == null) {
                        return Result.NEED_CHUNK;
                    }
                    BufferUtil.clearToFill((ByteBuffer)chunk);
                    this.prepareChunk(chunk, 0);
                    BufferUtil.flipToFlush((ByteBuffer)chunk, (int)0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
                this._state = State.END;
                return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
            }
            case END: {
                if (BufferUtil.hasContent((ByteBuffer)content)) {
                    LOG.debug("discarding content in COMPLETING", new Object[0]);
                    BufferUtil.clear((ByteBuffer)content);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    public Result generateResponse(ResponseInfo info, ByteBuffer header, ByteBuffer chunk, ByteBuffer content, boolean last) throws IOException {
        switch (this._state) {
            case START: {
                if (info == null) {
                    return Result.NEED_INFO;
                }
                if (info.getHttpVersion() == HttpVersion.HTTP_0_9) {
                    this._persistent = false;
                    this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
                    if (BufferUtil.hasContent((ByteBuffer)content)) {
                        this._contentPrepared += (long)content.remaining();
                    }
                    this._state = last ? State.COMPLETING : State.COMMITTED;
                    return Result.FLUSH;
                }
                if (header == null) {
                    return Result.NEED_HEADER;
                }
                if (this._persistent == null) {
                    this._persistent = info.getHttpVersion().ordinal() > HttpVersion.HTTP_1_0.ordinal();
                }
                int pos = BufferUtil.flipToFill((ByteBuffer)header);
                try {
                    this.generateResponseLine(info, header);
                    int status = info.getStatus();
                    if (status >= 100 && status < 200) {
                        this._noContent = true;
                        if (status != 101) {
                            header.put(HttpTokens.CRLF);
                            this._state = State.COMPLETING_1XX;
                            Result result = Result.FLUSH;
                            return result;
                        }
                    } else if (status == 204 || status == 304) {
                        this._noContent = true;
                    }
                    this.generateHeaders(info, header, content, last);
                    int len = BufferUtil.length((ByteBuffer)content);
                    if (len > 0) {
                        this._contentPrepared += (long)len;
                        if (this.isChunking() && !info.isHead()) {
                            this.prepareChunk(header, len);
                        }
                    }
                    this._state = last ? State.COMPLETING : State.COMMITTED;
                }
                catch (Exception e) {
                    String message = e instanceof BufferOverflowException ? "Response header too large" : e.getMessage();
                    throw new IOException(message, e);
                }
                finally {
                    BufferUtil.flipToFlush((ByteBuffer)header, (int)pos);
                }
                return Result.FLUSH;
            }
            case COMMITTED: {
                int len = BufferUtil.length((ByteBuffer)content);
                if (len > 0) {
                    if (this.isChunking()) {
                        if (chunk == null) {
                            return Result.NEED_CHUNK;
                        }
                        BufferUtil.clearToFill((ByteBuffer)chunk);
                        this.prepareChunk(chunk, len);
                        BufferUtil.flipToFlush((ByteBuffer)chunk, (int)0);
                    }
                    this._contentPrepared += (long)len;
                }
                if (last) {
                    this._state = State.COMPLETING;
                    return len > 0 ? Result.FLUSH : Result.CONTINUE;
                }
                return len > 0 ? Result.FLUSH : Result.DONE;
            }
            case COMPLETING_1XX: {
                this.reset();
                return Result.DONE;
            }
            case COMPLETING: {
                if (BufferUtil.hasContent((ByteBuffer)content)) {
                    LOG.debug("discarding content in COMPLETING", new Object[0]);
                    BufferUtil.clear((ByteBuffer)content);
                }
                if (this.isChunking()) {
                    if (chunk == null) {
                        return Result.NEED_CHUNK;
                    }
                    BufferUtil.clearToFill((ByteBuffer)chunk);
                    this.prepareChunk(chunk, 0);
                    BufferUtil.flipToFlush((ByteBuffer)chunk, (int)0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
                this._state = State.END;
                return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
            }
            case END: {
                if (BufferUtil.hasContent((ByteBuffer)content)) {
                    LOG.debug("discarding content in COMPLETING", new Object[0]);
                    BufferUtil.clear((ByteBuffer)content);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private void prepareChunk(ByteBuffer chunk, int remaining) {
        if (this._needCRLF) {
            BufferUtil.putCRLF((ByteBuffer)chunk);
        }
        if (remaining > 0) {
            BufferUtil.putHexInt((ByteBuffer)chunk, (int)remaining);
            BufferUtil.putCRLF((ByteBuffer)chunk);
            this._needCRLF = true;
        } else {
            chunk.put(LAST_CHUNK);
            this._needCRLF = false;
        }
    }

    private void generateRequestLine(RequestInfo request, ByteBuffer header) {
        header.put(StringUtil.getBytes((String)request.getMethod()));
        header.put((byte)32);
        header.put(StringUtil.getBytes((String)request.getUri()));
        switch (request.getHttpVersion()) {
            case HTTP_1_0: 
            case HTTP_1_1: {
                header.put((byte)32);
                header.put(request.getHttpVersion().toBytes());
            }
        }
        header.put(HttpTokens.CRLF);
    }

    private void generateResponseLine(ResponseInfo response, ByteBuffer header) {
        int status = response.getStatus();
        PreparedResponse preprepared = status < __preprepared.length ? __preprepared[status] : null;
        String reason = response.getReason();
        if (preprepared != null) {
            if (reason == null) {
                header.put(preprepared._responseLine);
            } else {
                header.put(preprepared._schemeCode);
                header.put(this.getReasonBytes(reason));
                header.put(HttpTokens.CRLF);
            }
        } else {
            header.put(HTTP_1_1_SPACE);
            header.put((byte)(48 + status / 100));
            header.put((byte)(48 + status % 100 / 10));
            header.put((byte)(48 + status % 10));
            header.put((byte)32);
            if (reason == null) {
                header.put((byte)(48 + status / 100));
                header.put((byte)(48 + status % 100 / 10));
                header.put((byte)(48 + status % 10));
            } else {
                header.put(this.getReasonBytes(reason));
            }
            header.put(HttpTokens.CRLF);
        }
    }

    private byte[] getReasonBytes(String reason) {
        if (reason.length() > 1024) {
            reason = reason.substring(0, 1024);
        }
        byte[] _bytes = StringUtil.getBytes((String)reason);
        int i = _bytes.length;
        while (i-- > 0) {
            if (_bytes[i] != 13 && _bytes[i] != 10) continue;
            _bytes[i] = 63;
        }
        return _bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateHeaders(Info _info, ByteBuffer header, ByteBuffer content, boolean last) {
        RequestInfo _request = _info instanceof RequestInfo ? (RequestInfo)_info : null;
        ResponseInfo _response = _info instanceof ResponseInfo ? (ResponseInfo)_info : null;
        boolean has_server = false;
        HttpFields.Field transfer_encoding = null;
        boolean keep_alive = false;
        boolean close = false;
        boolean content_type = false;
        StringBuilder connection = null;
        if (_info.getHttpFields() != null) {
            block19: for (HttpFields.Field field : _info.getHttpFields()) {
                HttpHeader name = field.getHeader();
                switch (name == null ? HttpHeader.UNKNOWN : name) {
                    case CONTENT_LENGTH: {
                        if (_info.getContentLength() < 0L) continue block19;
                        this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                        break;
                    }
                    case CONTENT_TYPE: {
                        if (field.getValue().startsWith(MimeTypes.Type.MULTIPART_BYTERANGES.toString())) {
                            this._endOfContent = HttpTokens.EndOfContent.SELF_DEFINING_CONTENT;
                        }
                        content_type = true;
                        field.putTo(header);
                        break;
                    }
                    case TRANSFER_ENCODING: {
                        if (_info.getHttpVersion() != HttpVersion.HTTP_1_1) continue block19;
                        transfer_encoding = field;
                        break;
                    }
                    case CONNECTION: {
                        int i;
                        if (_request != null) {
                            field.putTo(header);
                        }
                        HttpHeaderValue[] values = new HttpHeaderValue[]{(HttpHeaderValue)((Object)HttpHeaderValue.CACHE.get(field.getValue()))};
                        String[] split = null;
                        if (values[0] == null && (split = field.getValue().split("\\s*,\\s*")).length > 0) {
                            values = new HttpHeaderValue[split.length];
                            for (i = 0; i < split.length; ++i) {
                                values[i] = (HttpHeaderValue)((Object)HttpHeaderValue.CACHE.get(split[i]));
                            }
                        }
                        block21: for (i = 0; i < values.length; ++i) {
                            HttpHeaderValue value = values[i];
                            switch (value == null ? HttpHeaderValue.UNKNOWN : value) {
                                case UPGRADE: {
                                    header.put(HttpHeader.CONNECTION.getBytesColonSpace()).put(HttpHeader.UPGRADE.getBytes());
                                    header.put(CRLF);
                                    continue block21;
                                }
                                case CLOSE: {
                                    close = true;
                                    if (_response == null) continue block21;
                                    this._persistent = false;
                                    if (this._endOfContent != HttpTokens.EndOfContent.UNKNOWN_CONTENT) continue block21;
                                    this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
                                    continue block21;
                                }
                                case KEEP_ALIVE: {
                                    if (_info.getHttpVersion() != HttpVersion.HTTP_1_0) continue block21;
                                    keep_alive = true;
                                    if (_response == null) continue block21;
                                    this._persistent = true;
                                    continue block21;
                                }
                                default: {
                                    if (connection == null) {
                                        connection = new StringBuilder();
                                    } else {
                                        connection.append(',');
                                    }
                                    connection.append(split == null ? field.getValue() : split[i]);
                                }
                            }
                        }
                        continue block19;
                    }
                    case SERVER: {
                        if (!this.getSendServerVersion()) continue block19;
                        has_server = true;
                        field.putTo(header);
                        break;
                    }
                    default: {
                        if (name == null) {
                            field.putTo(header);
                            break;
                        }
                        header.put(name.getBytesColonSpace());
                        field.putValueTo(header);
                        header.put(CRLF);
                    }
                }
            }
        }
        int status = _response != null ? _response.getStatus() : -1;
        switch (this._endOfContent) {
            case UNKNOWN_CONTENT: {
                if (this._contentPrepared == 0L && _response != null && (status < 200 || status == 204 || status == 304)) {
                    this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                    break;
                }
                if (_info.getContentLength() > 0L) {
                    this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                    long content_length = _info.getContentLength();
                    if (_response == null && content_length <= 0L && !content_type || this._noContent) break;
                    header.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
                    BufferUtil.putDecLong((ByteBuffer)header, (long)content_length);
                    header.put(HttpTokens.CRLF);
                    break;
                }
                if (last) {
                    this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                    long content_length = this._contentPrepared + (long)BufferUtil.length((ByteBuffer)content);
                    if (_response == null && content_length <= 0L && !content_type || this._noContent) break;
                    header.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
                    BufferUtil.putDecLong((ByteBuffer)header, (long)content_length);
                    header.put(HttpTokens.CRLF);
                    break;
                }
                HttpTokens.EndOfContent endOfContent = this._endOfContent = !this.isPersistent() || _info.getHttpVersion().ordinal() < HttpVersion.HTTP_1_1.ordinal() ? HttpTokens.EndOfContent.EOF_CONTENT : HttpTokens.EndOfContent.CHUNKED_CONTENT;
                if (_response == null || this._endOfContent != HttpTokens.EndOfContent.EOF_CONTENT) break;
                this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                this._noContent = true;
                break;
            }
            case CONTENT_LENGTH: {
                long content_length = _info.getContentLength();
                if (_response == null && content_length <= 0L && !content_type || this._noContent) break;
                header.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
                BufferUtil.putDecLong((ByteBuffer)header, (long)content_length);
                header.put(HttpTokens.CRLF);
                break;
            }
            case NO_CONTENT: {
                if (_response == null || status < 200 || status == 204 || status == 304) break;
                header.put(CONTENT_LENGTH_0);
                break;
            }
            case EOF_CONTENT: {
                this._persistent = _request != null;
                break;
            }
            case CHUNKED_CONTENT: {
                break;
            }
        }
        if (this.isChunking()) {
            if (transfer_encoding != null && !HttpHeaderValue.CHUNKED.toString().equalsIgnoreCase(transfer_encoding.getValue())) {
                String c = transfer_encoding.getValue();
                if (!c.endsWith(HttpHeaderValue.CHUNKED.toString())) throw new IllegalArgumentException("BAD TE");
                transfer_encoding.putTo(header);
            } else {
                header.put(TRANSFER_ENCODING_CHUNKED);
            }
        }
        if (this._endOfContent == HttpTokens.EndOfContent.EOF_CONTENT) {
            keep_alive = false;
            this._persistent = false;
        }
        if (_response != null) {
            if (!this.isPersistent() && (close || _info.getHttpVersion().ordinal() > HttpVersion.HTTP_1_0.ordinal())) {
                if (connection == null) {
                    header.put(CONNECTION_CLOSE);
                } else {
                    header.put(CONNECTION_CLOSE, 0, CONNECTION_CLOSE.length - 2);
                    header.put((byte)44);
                    header.put(StringUtil.getBytes((String)connection.toString()));
                    header.put(CRLF);
                }
            } else if (keep_alive) {
                if (connection == null) {
                    header.put(CONNECTION_KEEP_ALIVE);
                } else {
                    header.put(CONNECTION_KEEP_ALIVE, 0, CONNECTION_CLOSE.length - 2);
                    header.put((byte)44);
                    header.put(StringUtil.getBytes((String)connection.toString()));
                    header.put(CRLF);
                }
            } else if (connection != null) {
                header.put(CONNECTION_);
                header.put(StringUtil.getBytes((String)connection.toString()));
                header.put(CRLF);
            }
        }
        if (!has_server && status > 199 && this.getSendServerVersion()) {
            header.put(SERVER);
        }
        header.put(HttpTokens.CRLF);
    }

    public static byte[] getReasonBuffer(int code) {
        PreparedResponse status;
        PreparedResponse preparedResponse = status = code < __preprepared.length ? __preprepared[code] : null;
        if (status != null) {
            return status._reason;
        }
        return null;
    }

    public String toString() {
        return String.format("%s{s=%s}", new Object[]{this.getClass().getSimpleName(), this._state});
    }

    static {
        int versionLength = HttpVersion.HTTP_1_1.toString().length();
        for (int i = 0; i < __preprepared.length; ++i) {
            HttpStatus.Code code = HttpStatus.getCode(i);
            if (code == null) continue;
            String reason = code.getMessage();
            byte[] line = new byte[versionLength + 5 + reason.length() + 2];
            HttpVersion.HTTP_1_1.toBuffer().get(line, 0, versionLength);
            line[versionLength + 0] = 32;
            line[versionLength + 1] = (byte)(48 + i / 100);
            line[versionLength + 2] = (byte)(48 + i % 100 / 10);
            line[versionLength + 3] = (byte)(48 + i % 10);
            line[versionLength + 4] = 32;
            for (int j = 0; j < reason.length(); ++j) {
                line[versionLength + 5 + j] = (byte)reason.charAt(j);
            }
            line[versionLength + 5 + reason.length()] = 13;
            line[versionLength + 6 + reason.length()] = 10;
            HttpGenerator.__preprepared[i] = new PreparedResponse();
            HttpGenerator.__preprepared[i]._reason = new byte[line.length - versionLength - 7];
            System.arraycopy(line, versionLength + 5, HttpGenerator.__preprepared[i]._reason, 0, line.length - versionLength - 7);
            HttpGenerator.__preprepared[i]._schemeCode = new byte[versionLength + 5];
            System.arraycopy(line, 0, HttpGenerator.__preprepared[i]._schemeCode, 0, versionLength + 5);
            HttpGenerator.__preprepared[i]._responseLine = line;
        }
    }

    public static class ResponseInfo
    extends Info {
        private final int _status;
        private final String _reason;
        private final boolean _head;

        public ResponseInfo(HttpVersion httpVersion, HttpFields httpFields, long contentLength, int status, String reason, boolean head) {
            super(httpVersion, httpFields, contentLength);
            this._status = status;
            this._reason = reason;
            this._head = head;
        }

        public boolean isInformational() {
            return this._status >= 100 && this._status < 200;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        public boolean isHead() {
            return this._head;
        }

        public String toString() {
            return String.format("ResponseInfo{%s %s %s,%d,%b}", new Object[]{this._httpVersion, this._status, this._reason, this._contentLength, this._head});
        }
    }

    public static class RequestInfo
    extends Info {
        private final String _method;
        private final String _uri;

        public RequestInfo(HttpVersion httpVersion, HttpFields httpFields, long contentLength, String method, String uri) {
            super(httpVersion, httpFields, contentLength);
            this._method = method;
            this._uri = uri;
        }

        public String getMethod() {
            return this._method;
        }

        public String getUri() {
            return this._uri;
        }

        public String toString() {
            return String.format("RequestInfo{%s %s %s,%d}", new Object[]{this._method, this._uri, this._httpVersion, this._contentLength});
        }
    }

    public static class Info {
        final HttpVersion _httpVersion;
        final HttpFields _httpFields;
        final long _contentLength;

        private Info(HttpVersion httpVersion, HttpFields httpFields, long contentLength) {
            this._httpVersion = httpVersion;
            this._httpFields = httpFields;
            this._contentLength = contentLength;
        }

        public HttpVersion getHttpVersion() {
            return this._httpVersion;
        }

        public HttpFields getHttpFields() {
            return this._httpFields;
        }

        public long getContentLength() {
            return this._contentLength;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }

    public static enum Result {
        NEED_CHUNK,
        NEED_INFO,
        NEED_HEADER,
        FLUSH,
        CONTINUE,
        SHUTDOWN_OUT,
        DONE;

    }

    public static enum State {
        START,
        COMMITTED,
        COMPLETING,
        COMPLETING_1XX,
        END;

    }
}

