/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.PredicateDescr;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.java.JavaRuleBuilderHelper;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DeclarationScopeResolver;

public abstract class AbstractASMEvalBuilder
implements RuleConditionBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        EvalDescr evalDescr = (EvalDescr)descr;
        Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
        Dialect dialect = context.getDialect();
        Object object = evalDescr.getContent();
        context.getDeclarationResolver();
        AnalysisResult analysis = dialect.analyzeExpression(context, evalDescr, object, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getKnowledgeBuilder().getGlobals()));
        ArrayList<Declaration> requiredDeclarations = new ArrayList<Declaration>();
        for (String usedIdentifier : analysis.getIdentifiers()) {
            Declaration usedDec = (Declaration)decls.get(usedIdentifier);
            if (usedDec == null) continue;
            requiredDeclarations.add(usedDec);
        }
        Declaration[] declarations = requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]);
        return this.buildEval(context, evalDescr, analysis, declarations);
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        if (prefixPattern == null) {
            return this.build(context, descr);
        }
        EvalDescr evalDescr = (EvalDescr)descr;
        PredicateDescr predicateDescr = new PredicateDescr(context.getRuleDescr().getResource(), evalDescr.getContent());
        AnalysisResult analysis = PatternBuilder.buildAnalysis(context, prefixPattern, predicateDescr, null);
        Declaration[] declarations = this.getUsedDeclarations(context, prefixPattern, analysis);
        return this.buildEval(context, evalDescr, analysis, declarations);
    }

    private RuleConditionElement buildEval(RuleBuildContext context, EvalDescr evalDescr, AnalysisResult analysis, Declaration[] declarations) {
        String className = "eval" + context.getNextId();
        evalDescr.setClassMethodName(className);
        Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
        EvalCondition eval = new EvalCondition(declarations);
        Map<String, Object> vars = JavaRuleBuilderHelper.createVariableContext(className, (String)evalDescr.getContent(), context, declarations, null, analysis.getBoundIdentifiers().getGlobals());
        JavaRuleBuilderHelper.generateMethodTemplate("evalMethod", context, vars);
        byte[] bytecode = this.createEvalBytecode(context, vars);
        JavaRuleBuilderHelper.registerInvokerBytecode(context, vars, bytecode, eval);
        return eval;
    }

    private Declaration[] getUsedDeclarations(RuleBuildContext context, Pattern pattern, AnalysisResult analysis) {
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            declarations.add(context.getDeclarationResolver().getDeclaration(context.getRule(), id));
        }
        PatternBuilder.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), analysis.getBoundIdentifiers(), declarations);
        return declarations.toArray(new Declaration[declarations.size()]);
    }

    protected abstract byte[] createEvalBytecode(RuleBuildContext var1, Map var2);
}

