/*
 *  ******************************************************************************
 *  *
 *  *
 *  * This program and the accompanying materials are made available under the
 *  * terms of the Apache License, Version 2.0 which is available at
 *  * https://www.apache.org/licenses/LICENSE-2.0.
 *  *
 *  *  See the NOTICE file distributed with this work for additional
 *  *  information regarding copyright ownership.
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  * License for the specific language governing permissions and limitations
 *  * under the License.
 *  *
 *  * SPDX-License-Identifier: Apache-2.0
 *  *****************************************************************************
 */

package org.deeplearning4j.zoo;

import org.deeplearning4j.nn.api.Model;

public interface InstantiableModel {

    void setInputShape(int[][] inputShape);

    <M extends Model> M init();

    /**
     * @deprecated No longer used, will be removed in a future release
     */
    @Deprecated ModelMetaData metaData();

    Class<? extends Model> modelType();

    String pretrainedUrl(PretrainedType pretrainedType);

    long pretrainedChecksum(PretrainedType pretrainedType);

    String modelName();
}
