/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class ScrollableMultiDataSetIterator
implements MultiDataSetIterator {
    private int thisPart = 0;
    private int top = 0;
    private int bottom = 0;
    protected MultiDataSetIterator backedIterator;
    protected AtomicLong counter = new AtomicLong(0L);
    protected AtomicBoolean resetPending = new AtomicBoolean(false);
    protected DataSet firstTrain = null;
    protected MultiDataSet firstMultiTrain = null;
    private double ratio;
    private long totalExamples;
    private long itemsPerPart;
    private long current;

    public ScrollableMultiDataSetIterator(int num, MultiDataSetIterator backedIterator, AtomicLong counter, MultiDataSet firstTrain, int[] itemsPerPart) {
        this.thisPart = num;
        this.bottom = itemsPerPart[0];
        this.top = this.bottom + itemsPerPart[1];
        this.itemsPerPart = this.top;
        this.counter = counter;
        this.firstTrain = null;
        this.firstMultiTrain = firstTrain;
        this.current = 0L;
        this.backedIterator = backedIterator;
        this.resetPending = this.resetPending;
    }

    public boolean resetSupported() {
        return this.backedIterator.resetSupported();
    }

    public boolean asyncSupported() {
        return this.backedIterator.asyncSupported();
    }

    public void reset() {
        this.resetPending.set(true);
    }

    public void setPreProcessor(MultiDataSetPreProcessor dataSetPreProcessor) {
        this.backedIterator.setPreProcessor(dataSetPreProcessor);
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        if (this.resetPending.get()) {
            if (this.resetSupported()) {
                this.backedIterator.reset();
                this.counter.set(0L);
                this.current = 0L;
                this.resetPending.set(false);
            } else {
                throw new UnsupportedOperationException("Reset isn't supported by underlying iterator");
            }
        }
        boolean state = false;
        if (this.current >= (long)this.top) {
            return false;
        }
        state = this.backedIterator.hasNext();
        if (!state) {
            return false;
        }
        return state && this.counter.get() < this.itemsPerPart;
    }

    public MultiDataSet next() {
        this.counter.incrementAndGet();
        if (this.current == 0L && this.bottom != 0) {
            long cnt;
            this.backedIterator.reset();
            for (cnt = this.current; cnt < (long)this.bottom; ++cnt) {
                if (!this.backedIterator.hasNext()) continue;
                this.backedIterator.next();
            }
            this.current = cnt + 1L;
        } else {
            ++this.current;
        }
        MultiDataSet p = (MultiDataSet)this.backedIterator.next();
        return p;
    }

    public void remove() {
    }

    public MultiDataSet next(int i) {
        throw new UnsupportedOperationException();
    }
}

