/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.unittest;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.debux.webmotion.unittest.RequestBuilder;

public abstract class WebMotionTest {
    static AtomicBoolean isStarted = new AtomicBoolean(false);
    protected Tomcat server;

    protected void startServer() throws Exception {
        String[] classpath;
        this.server = new Tomcat();
        this.server.setPort(this.getPort());
        WebappLoader loader = new WebappLoader(this.getClass().getClassLoader());
        String classpaths = System.getProperty("java.class.path");
        for (String path : classpath = classpaths.split(":")) {
            loader.addRepository(new File(path).toURI().toURL().toString());
        }
        StandardContext rootContext = (StandardContext)this.server.addWebapp(this.getContextPath(), new File(this.getWebappLocation()).getAbsolutePath());
        rootContext.setLoader((Loader)loader);
        rootContext.setReloadable(true);
        rootContext.setUnpackWAR(false);
        ((StandardJarScanner)rootContext.getJarScanner()).setScanAllDirectories(true);
        this.server.enableNaming();
        this.server.start();
    }

    protected void stopServer() throws Exception {
        this.server.stop();
    }

    public void runServer() throws Exception {
        boolean value = isStarted.getAndSet(true);
        if (!value) {
            this.startServer();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        WebMotionTest.this.stopServer();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        isStarted.set(false);
                    }
                }
            });
        }
    }

    protected int getPort() {
        return 9999;
    }

    protected String getContextPath() {
        return "/";
    }

    protected String getWebappLocation() {
        return "src/main/webapp";
    }

    public RequestBuilder createRequest(String url) {
        String contextPath = this.getContextPath();
        String path = contextPath.endsWith("/") && url.startsWith("/") ? this.getContextPath() + url.substring(1) : (contextPath.endsWith("/") ^ url.startsWith("/") ? this.getContextPath() + url : this.getContextPath() + "/" + url);
        RequestBuilder builder = new RequestBuilder().setScheme("http").setHost("localhost").setPort(this.getPort()).setPath(path);
        return builder;
    }
}

