/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.MapKey;
import javax.persistence.Parameter;
import javax.persistence.Query;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.ArrayUtils;
import org.debux.webmotion.jpa.IdentifiableEntity;
import org.debux.webmotion.server.WebMotionException;

public class GenericDAO {
    protected BeanUtilsBean beanUtil;
    protected ConvertUtilsBean convertUtils;
    protected PropertyUtilsBean propertyUtils;
    protected EntityManager manager;
    protected Class<? extends IdentifiableEntity> entityClass;

    public GenericDAO(EntityManager manager, Class<? extends IdentifiableEntity> entityClass) {
        this.manager = manager;
        this.entityClass = entityClass;
        this.beanUtil = BeanUtilsBean.getInstance();
        this.convertUtils = this.beanUtil.getConvertUtils();
        this.propertyUtils = this.beanUtil.getPropertyUtils();
    }

    public GenericDAO(EntityManager manager, String entityName) {
        this.manager = manager;
        try {
            this.entityClass = Class.forName(entityName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new WebMotionException("Invalid class name", (Throwable)cnfe);
        }
        this.beanUtil = BeanUtilsBean.getInstance();
        this.convertUtils = this.beanUtil.getConvertUtils();
        this.propertyUtils = this.beanUtil.getPropertyUtils();
    }

    public IdentifiableEntity create(Parameters parameters) {
        IdentifiableEntity entity = this.extract(parameters);
        this.manager.persist((Object)entity);
        return entity;
    }

    public IdentifiableEntity update(String id, Parameters parameters) {
        IdentifiableEntity entity = (IdentifiableEntity)this.manager.find(this.entityClass, (Object)id);
        if (entity != null) {
            entity = this.extract(entity, parameters);
        }
        return entity;
    }

    public boolean delete(String id) {
        IdentifiableEntity entity = (IdentifiableEntity)this.manager.find(this.entityClass, (Object)id);
        if (entity != null) {
            this.manager.remove((Object)entity);
            return true;
        }
        return false;
    }

    public IdentifiableEntity find(String id) {
        IdentifiableEntity entity = (IdentifiableEntity)this.manager.find(this.entityClass, (Object)id);
        return entity;
    }

    public List query(String name, Parameters parameters) {
        Query query = this.manager.createNamedQuery(name);
        this.extract(query, parameters);
        List list = query.getResultList();
        return list;
    }

    public int exec(String name, Parameters parameters) {
        Query query = this.manager.createNamedQuery(name);
        this.extract(query, parameters);
        int executeUpdate = query.executeUpdate();
        return executeUpdate;
    }

    protected void extract(Query query, Parameters parameters) {
        Set queryParameters = query.getParameters();
        for (Parameter parameter : queryParameters) {
            String parameterName = parameter.getName();
            Object[] values = parameters.get(parameterName);
            List<Object> converted = Arrays.asList(values);
            query.setParameter(parameterName, converted);
        }
    }

    protected IdentifiableEntity extract(Parameters parameters) {
        try {
            IdentifiableEntity entity = this.entityClass.newInstance();
            return this.extract(entity, parameters);
        }
        catch (IllegalAccessException iae) {
            throw new WebMotionException("Error during create instance", (Throwable)iae);
        }
        catch (InstantiationException ie) {
            throw new WebMotionException("Not default constructor", (Throwable)ie);
        }
    }

    protected IdentifiableEntity extract(IdentifiableEntity entity, Parameters parameters) {
        try {
            Field[] fields;
            for (Field field : fields = this.entityClass.getDeclaredFields()) {
                String name = field.getName();
                Class<?> type = field.getType();
                Object[] values = parameters.get(name);
                if (IdentifiableEntity.ATTRIBUTE_NAME_ID.equals(name) || values == null) continue;
                if (values.length == 0) {
                    this.beanUtil.setProperty((Object)entity, name, null);
                    continue;
                }
                if (type.isAnnotationPresent(Entity.class)) {
                    ArrayList<Object> references = new ArrayList<Object>(values.length);
                    for (Object value : values) {
                        Object reference = this.manager.find(type, value);
                        if (reference == null) continue;
                        references.add(reference);
                    }
                    Object converted = null;
                    if (List.class.isAssignableFrom(type)) {
                        converted = references;
                    } else if (Set.class.isAssignableFrom(type)) {
                        converted = new HashSet(references);
                    } else if (SortedSet.class.isAssignableFrom(type)) {
                        converted = new TreeSet(references);
                    } else if (type.isArray()) {
                        converted = references.toArray();
                    } else if (Map.class.isAssignableFrom(type)) {
                        String annotationName;
                        String keyName = IdentifiableEntity.ATTRIBUTE_NAME_ID;
                        MapKey annotation = type.getAnnotation(MapKey.class);
                        if (annotation != null && (annotationName = annotation.name()) != null && !annotationName.isEmpty()) {
                            keyName = annotationName;
                        }
                        HashMap<Object, Object> map = new HashMap<Object, Object>();
                        for (Object object : references) {
                            Object key = this.propertyUtils.getProperty(object, keyName);
                            map.put(key, object);
                        }
                        converted = map;
                    } else if (!references.isEmpty()) {
                        converted = references.get(0);
                    }
                    this.beanUtil.setProperty((Object)entity, name, converted);
                    continue;
                }
                if (Collection.class.isAssignableFrom(type)) {
                    Class convertType = String.class;
                    Type genericType = field.getGenericType();
                    if (genericType != null && genericType instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)genericType;
                        convertType = (Class)parameterizedType.getActualTypeArguments()[0];
                    }
                    AbstractCollection collection = null;
                    collection = Set.class.isAssignableFrom(type) ? new HashSet() : (SortedSet.class.isAssignableFrom(type) ? new TreeSet() : new ArrayList());
                    for (Object object : values) {
                        Object convertedObject = this.convertUtils.convert(object, convertType);
                        collection.add(convertedObject);
                    }
                    this.beanUtil.setProperty((Object)entity, name, collection);
                    continue;
                }
                if (Map.class.isAssignableFrom(type)) {
                    throw new UnsupportedOperationException("Map is not supported, you must create a specific entity.");
                }
                Object converted = this.convertUtils.convert((Object)values, type);
                this.beanUtil.setProperty((Object)entity, name, converted);
            }
            return entity;
        }
        catch (IllegalAccessException iae) {
            throw new WebMotionException("Error during create instance", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new WebMotionException("Error during set field on instance", (Throwable)ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new WebMotionException("Error during set field on instance", (Throwable)nsme);
        }
    }

    public static class Parameters {
        protected Map<String, Object[]> parameters;

        public Parameters() {
            this(new HashMap<String, Object[]>());
        }

        public Parameters(Map<String, Object[]> parameters) {
            this.parameters = parameters;
        }

        public static Parameters create() {
            return new Parameters();
        }

        public static Parameters create(Map values) {
            return new Parameters(values);
        }

        public Parameters addAll(Map parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public Parameters add(String name, Object[] values) {
            this.parameters.put(name, values);
            return this;
        }

        public Parameters add(String name) {
            this.parameters.put(name, new Object[0]);
            return this;
        }

        public Parameters add(String name, Object value) {
            Object[] values = this.parameters.get(name);
            values = values == null ? new Object[]{value} : ArrayUtils.add((Object[])values, (Object)value);
            this.parameters.put(name, values);
            return this;
        }

        public Map<String, Object[]> getParameters() {
            return this.parameters;
        }

        public Object[] get(String name) {
            return this.parameters.get(name);
        }
    }
}

