/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven3;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.MavenProjectConverter;
import org.sonar.batch.bootstrapper.Batch;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.LoggingConfiguration;
import org.sonar.maven3.Maven3PluginExecutor;

public final class SonarMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private LifecycleExecutor lifecycleExecutor;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder projectBuilder;
    private RuntimeInformation runtimeInformation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectDefinition def = MavenProjectConverter.convert((List)this.session.getSortedProjects(), (MavenProject)this.project);
        ProjectReactor reactor = new ProjectReactor(def);
        Batch batch = Batch.builder().setEnvironment(this.getEnvironmentInformation()).setProjectReactor(reactor).addComponents(new Object[]{this.session, this.getLog(), this.lifecycleExecutor, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder, this.projectBuilder, Maven3PluginExecutor.class}).build();
        this.configureLogging(batch.getLoggingConfiguration());
        batch.execute();
    }

    private void configureLogging(LoggingConfiguration logging) {
        logging.setProperties((Map)Maps.fromProperties((Properties)this.session.getSystemProperties()));
        logging.setFormat("[%level] [%d{HH:mm:ss.SSS}] %msg%n");
        if (this.getLog().isDebugEnabled()) {
            logging.setVerbose(true);
        }
    }

    private EnvironmentInformation getEnvironmentInformation() {
        String mavenVersion = this.runtimeInformation.getApplicationVersion().toString();
        return new EnvironmentInformation("Maven", mavenVersion);
    }
}

