/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.cdc.ComponentDescriptorCreator;
import org.codehaus.plexus.cdc.ComponentDescriptorCreatorException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractMergeMojo
extends AbstractMojo {
    private File[] descriptors;
    private ComponentDescriptorCreator cdc;

    protected abstract List getResources();

    protected abstract File getOutput();

    public void execute() throws MojoExecutionException {
        ArrayList<File> files = new ArrayList<File>();
        Iterator it = this.getResources().iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            String includes = "META-INF/plexus/components.xml";
            String excludes = "";
            Iterator j = resource.getExcludes().iterator();
            while (j.hasNext()) {
                String exclude = (String)j.next();
                excludes = excludes + exclude + ",";
            }
            try {
                File basedir = new File(resource.getDirectory());
                this.getLog().debug((CharSequence)("Searching for component.xml files. Basedir: " + basedir.getAbsolutePath() + ", includes: " + includes + ", excludes=" + excludes));
                if (!basedir.isDirectory()) {
                    this.getLog().debug((CharSequence)"Skipping, not a directory.");
                    continue;
                }
                List list = FileUtils.getFiles((File)basedir, (String)includes, (String)excludes);
                files.addAll(list);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while scanning for component.xml files.", (Exception)e);
            }
        }
        if (this.descriptors != null) {
            files.addAll(Arrays.asList(this.descriptors));
        }
        if (files.isEmpty()) {
            this.getLog().debug((CharSequence)"Didn't find any files to merge.");
            return;
        }
        this.getLog().debug((CharSequence)("Found " + files.size() + " files to merge:"));
        it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            this.getLog().debug((CharSequence)file.getAbsolutePath());
        }
        try {
            this.cdc.mergeDescriptors(this.getOutput(), files);
        }
        catch (ComponentDescriptorCreatorException e) {
            throw new MojoExecutionException("Error while executing component descritor creator.", (Exception)((Object)e));
        }
    }
}

