/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml.format;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import org.codehaus.mojo.xml.format.XmlFormatViolation;
import org.codehaus.mojo.xml.format.XmlFormatViolationHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IndentCheckSaxHandler
extends DefaultHandler {
    private final StringBuilder charBuffer = new StringBuilder();
    private int charLineNumber;
    private final File file;
    private final int indentSize;
    private Indent lastIndent = Indent.START;
    private Locator locator;
    private Deque<ElementEntry> stack = new ArrayDeque<ElementEntry>();
    private final XmlFormatViolationHandler violationHandler;

    public IndentCheckSaxHandler(File file, int indentSize, XmlFormatViolationHandler violationHandler) {
        this.file = file;
        this.indentSize = indentSize;
        this.violationHandler = violationHandler;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charBuffer.append(ch, start, length);
        this.charLineNumber = this.locator.getLineNumber();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushCharacters();
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Stack must not be empty when closing the element " + qName + " around line " + this.locator.getLineNumber() + " and column " + this.locator.getColumnNumber());
        }
        ElementEntry startEntry = this.stack.pop();
        int indentDiff = this.lastIndent.size - startEntry.expectedIndent.size;
        int expectedIndent = startEntry.expectedIndent.size;
        if (this.lastIndent.lineNumber != startEntry.foundIndent.lineNumber && indentDiff != 0) {
            int opValue = expectedIndent - this.lastIndent.size;
            String op = opValue > 0 ? "Insert" : "Delete";
            String units = opValue == 1 ? "space" : "spaces";
            String message = op + " " + Math.abs(opValue) + " " + units + ". Expected " + expectedIndent + " found " + this.lastIndent.size + " spaces before end element </" + qName + ">";
            XmlFormatViolation violation = new XmlFormatViolation(this.file, this.locator.getLineNumber(), this.locator.getColumnNumber(), message);
            this.violationHandler.handle(violation);
        }
    }

    private void flushCharacters() {
        int indentLength = 0;
        int len = this.charBuffer.length();
        block4: for (int i = len - 1; i >= 0; --i) {
            char ch = this.charBuffer.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    this.lastIndent = new Indent(this.charLineNumber, indentLength);
                    this.charBuffer.setLength(0);
                    return;
                }
                case '\t': 
                case ' ': {
                    ++indentLength;
                    continue block4;
                }
                default: {
                    this.charBuffer.setLength(0);
                    return;
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        this.characters(chars, start, length);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.flushCharacters();
        ElementEntry currentEntry = new ElementEntry(qName, this.lastIndent);
        if (!this.stack.isEmpty()) {
            ElementEntry parentEntry = this.stack.peek();
            int indentDiff = currentEntry.foundIndent.size - parentEntry.expectedIndent.size;
            int expectedIndent = parentEntry.expectedIndent.size + this.indentSize;
            if ((indentDiff != 0 || currentEntry.foundIndent.lineNumber != parentEntry.foundIndent.lineNumber) && indentDiff != this.indentSize) {
                int opValue = expectedIndent - currentEntry.foundIndent.size;
                String op = opValue > 0 ? "Insert" : "Delete";
                String message = op + " " + Math.abs(opValue) + " spaces. Expected " + expectedIndent + " found " + currentEntry.foundIndent.size + " spaces before start element <" + currentEntry.elementName + ">";
                XmlFormatViolation violation = new XmlFormatViolation(this.file, this.locator.getLineNumber(), this.locator.getColumnNumber(), message);
                this.violationHandler.handle(violation);
                currentEntry = new ElementEntry(qName, this.lastIndent, new Indent(this.lastIndent.lineNumber, expectedIndent));
            }
        }
        this.stack.push(currentEntry);
    }

    private static class Indent {
        public static final Indent START = new Indent(1, 0);
        private final int lineNumber;
        private final int size;

        public Indent(int lineNumber, int size) {
            this.lineNumber = lineNumber;
            this.size = size;
        }

        public String toString() {
            return "Indent [size=" + this.size + ", lineNumber=" + this.lineNumber + "]";
        }
    }

    private static class ElementEntry {
        private final String elementName;
        private final Indent expectedIndent;
        private final Indent foundIndent;

        public ElementEntry(String elementName, Indent foundIndent) {
            this.elementName = elementName;
            this.foundIndent = foundIndent;
            this.expectedIndent = foundIndent;
        }

        public ElementEntry(String elementName, Indent foundIndent, Indent expectedIndent) {
            this.elementName = elementName;
            this.foundIndent = foundIndent;
            this.expectedIndent = expectedIndent;
        }

        public String toString() {
            return "<" + this.elementName + "> " + this.foundIndent;
        }
    }
}

