/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xdoclet;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antrun.AbstractAntMojo;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Taskdef;

public class XDocletMojo
extends AbstractAntMojo {
    private static final String XDOCLET_CP = "xdoclet.class.path";
    private MavenProject project;
    private File generatedSourcesDirectory;
    private Target tasks;
    private Collection pluginArtifacts;
    private boolean isInitialized = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        String oldXDocletClasspath;
        block8: {
            oldXDocletClasspath = System.getProperty(XDOCLET_CP);
            try {
                try {
                    String classpath = this.createClasspath();
                    this.getLog().debug((CharSequence)("XDoclet classpath = " + classpath));
                    System.setProperty(XDOCLET_CP, classpath);
                    this.initializeDocletMappings();
                    this.executeTasks(this.tasks, this.project);
                    if (this.generatedSourcesDirectory.exists()) {
                        this.project.addCompileSourceRoot(this.generatedSourcesDirectory.getAbsolutePath());
                    }
                }
                catch (MojoExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error", e);
                }
                Object var4_5 = null;
                if (oldXDocletClasspath != null) break block8;
                System.getProperties().remove(XDOCLET_CP);
                return;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (oldXDocletClasspath == null) {
                    System.getProperties().remove(XDOCLET_CP);
                    throw throwable;
                }
                System.setProperty(XDOCLET_CP, oldXDocletClasspath);
                throw throwable;
            }
        }
        System.setProperty(XDOCLET_CP, oldXDocletClasspath);
    }

    private String createClasspath() {
        StringBuffer buffer = new StringBuffer(1024);
        Iterator it = this.pluginArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (buffer.length() > 0) {
                buffer.append(File.pathSeparatorChar);
            }
            if (artifact.getFile() == null) continue;
            buffer.append(artifact.getFile().getAbsolutePath());
        }
        return buffer.toString();
    }

    private void initializeDocletMappings() {
        if (this.isInitialized) {
            this.getLog().info((CharSequence)"TaskDefinitions already in place");
            return;
        }
        this.getLog().info((CharSequence)"Initializing DocletTasks!!!");
        String[] mappings = new String[]{"doclet", "xdoclet.DocletTask", "tapestrydoclet", "xdoclet.modules.apache.tapestry.TapestryDocletTask", "docdoclet", "xdoclet.modules.doc.DocumentDocletTask", "ejbdoclet", "xdoclet.modules.ejb.EjbDocletTask", "hibernatedoclet", "xdoclet.modules.hibernate.HibernateDocletTask", "jdodoclet", "xdoclet.modules.jdo.JdoDocletTask", "jmxdoclet", "xdoclet.modules.jmx.JMXDocletTask", "mockdoclet", "xdoclet.modules.mockobjects.MockObjectDocletTask", "portletdoclet", "xdoclet.modules.portlet.PortletDocletTask", "springdoclet", "xdoclet.modules.spring.SpringDocletTask", "webdoclet", "xdoclet.modules.web.WebDocletTask", "wseedoclet", "xdoclet.modules.wsee.WseeDocletTask"};
        for (int i = 0; i < mappings.length; i += 2) {
            Taskdef taskDef = new Taskdef();
            taskDef.setProject(this.tasks.getProject());
            taskDef.setName(mappings[i]);
            taskDef.setClassname(mappings[i + 1]);
            taskDef.setOwningTarget(this.tasks);
            taskDef.perform();
        }
        this.isInitialized = true;
    }
}

