/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.boundary.HtmlUnitBoundary;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import javax.xml.xpath.XPathException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DragAndDrop
extends Step {
    private static final Logger LOG = Logger.getLogger(DragAndDrop.class);
    private String fFromXPath_;
    private String fToXPath_;
    private String fFromHtmlId_;
    private String fToHtmlId_;

    public String getFromXPath() {
        return this.fFromXPath_;
    }

    public void setFromXPath(String _fromXPath) {
        this.fFromXPath_ = _fromXPath;
    }

    public String getToXPath() {
        return this.fToXPath_;
    }

    public void setToXPath(String _toXPath) {
        this.fToXPath_ = _toXPath;
    }

    public String getFromHtmlId() {
        return this.fFromHtmlId_;
    }

    public void setFromHtmlId(String _fromHtmlId) {
        this.fFromHtmlId_ = _fromHtmlId;
    }

    public String getToHtmlId() {
        return this.fToHtmlId_;
    }

    public void setToHtmlId(String _toHtmlId) {
        this.fToHtmlId_ = _toHtmlId;
    }

    public void doExecute() throws Exception {
        HtmlPage page = this.getContext().getCurrentHtmlResponse(this);
        HtmlElement from = this.getByXPathOrId("From element", page, this.getFromXPath(), this.getFromHtmlId());
        HtmlElement to = this.getByXPathOrId("To element", page, this.getToXPath(), this.getToHtmlId());
        from.mouseDown();
        to.mouseMove();
        to.mouseUp();
    }

    private HtmlElement getByXPathOrId(String description, HtmlPage page, String xpath, String htmlId) throws XPathException {
        HtmlElement elt;
        if (!StringUtils.isEmpty((String)htmlId)) {
            try {
                elt = page.getHtmlElementById(htmlId);
            }
            catch (ElementNotFoundException e) {
                throw new StepFailedException(description + ": no element found with id >" + htmlId + "<");
            }
        } else {
            Object node = HtmlUnitBoundary.trySelectSingleNodeByXPath(xpath, (Page)page, this);
            LOG.debug((Object)("XPath >" + xpath + "< evaluates to: " + node));
            if (node == null) {
                throw new StepFailedException(description + ": no element found with xpath >" + xpath + "<");
            }
            if (node instanceof HtmlElement) {
                elt = (HtmlElement)node;
            } else {
                throw new StepFailedException("The xpath doesn't select an HTML element but a '" + node.getClass() + "'");
            }
        }
        return elt;
    }

    protected void verifyParameters() {
        this.nullResponseCheck();
        this.paramCheck(this.getFromHtmlId() == null && this.getFromXPath() == null, "\"fromHtmlId\" or \"fromXPath\" must be set!");
        this.paramCheck(this.getFromHtmlId() != null && this.getFromXPath() != null, "Only one from \"fromHtmlId\" and \"fromXPath\" can be set!");
        this.paramCheck(this.getToHtmlId() == null && this.getToXPath() == null, "\"toHtmlId\" or \"toXPath\" must be set!");
        this.paramCheck(this.getToHtmlId() != null && this.getToXPath() != null, "Only one from \"toHtmlId\" and \"toXPath\" can be set!");
    }
}

