/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.reporting;

import com.canoo.webtest.ant.IPropertyExpansionListener;
import com.canoo.webtest.ant.TestStepSequence;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.engine.MimeMap;
import com.canoo.webtest.engine.NOPBuildListener;
import com.canoo.webtest.engine.WebClientContext;
import com.canoo.webtest.reporting.IStepResultListener;
import com.canoo.webtest.reporting.RootStepResult;
import com.canoo.webtest.reporting.StepResult;
import com.canoo.webtest.steps.HtmlParserMessage;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Task;

public class StepExecutionListener
extends NOPBuildListener
implements IStepResultListener,
IPropertyExpansionListener {
    private static final Logger LOG = Logger.getLogger(StepExecutionListener.class);
    private StepResult fCurrentResult;
    private final HtmlParserMessage.MessageCollector fHtmlParserMessageCollector;
    private final Context fContext;
    private Page fPreviousCurrentResponse;
    private WebClientContext.StoredResponses fPreviousResponses;
    private boolean domChangedInLastPage = false;
    private int resultIndex = 0;
    private final Thread owningThread;
    private final DomChangeListener domChangeListener = new DomChangeListener(){

        public void nodeAdded(DomChangeEvent event) {
            StepExecutionListener.this.domChangedInLastPage = true;
        }

        public void nodeDeleted(DomChangeEvent event) {
            StepExecutionListener.this.domChangedInLastPage = true;
        }
    };
    private RootStepResult fRootResult;
    private boolean fIgnoreCurrentTasks;

    public StepExecutionListener(Context context) {
        this.owningThread = Thread.currentThread();
        this.fContext = context;
        this.fHtmlParserMessageCollector = context.getConfig().isShowHtmlParserOutput() ? (HtmlParserMessage.MessageCollector)context.getWebClient().getHTMLParserListener() : null;
    }

    protected List getLastHtmlParserMessages() {
        if (this.fHtmlParserMessageCollector == null) {
            return new ArrayList();
        }
        return this.fHtmlParserMessageCollector.popAll();
    }

    public RootStepResult getRootResult() {
        return this.fRootResult;
    }

    protected boolean isInteresting(Task task) {
        if (this.fIgnoreCurrentTasks) {
            LOG.debug((Object)("currently ignoring: " + task));
            return false;
        }
        if (this.isToIgnore(task)) {
            LOG.debug((Object)("toIgnore: " + task));
            this.fIgnoreCurrentTasks = true;
            return false;
        }
        return !"sequential".equals(task.getTaskName());
    }

    protected boolean isToIgnore(Task task) {
        return "antlib".equals(task.getTaskName());
    }

    public void propertiesExpanded(String originalValue, String expanded) {
        if (!this.isEventForMe()) {
            return;
        }
        this.fCurrentResult.propertiesExpanded(originalValue, expanded);
    }

    public void stepResults(Map results) {
        if (!this.isEventForMe()) {
            return;
        }
        this.fCurrentResult.addStepResults(results);
    }

    public void taskFinished(BuildEvent event) {
        if (!this.isEventForMe()) {
            return;
        }
        Task task = event.getTask();
        LOG.trace((Object)("taskFinished: " + task.getTaskName()), event.getException());
        if (this.isToIgnore(task)) {
            this.fIgnoreCurrentTasks = false;
            return;
        }
        if (!this.isInteresting(task)) {
            return;
        }
        if (this.fCurrentResult == null) {
            throw new IllegalStateException("No current result");
        }
        List liHtmlParserMessages = this.getLastHtmlParserMessages();
        if (!this.fCurrentResult.isSuccessful()) {
            Throwable exception = event.getException();
            this.fRootResult.setLastFailingTaskResult(this.fCurrentResult, exception);
        }
        this.fCurrentResult.taskFinished(task, event.getException(), liHtmlParserMessages);
        this.saveCurrentResponseIfNeeded(event);
        if (event.getException() != null && this.fPreviousResponses != null) {
            this.fContext.restoreResponses(this.fPreviousResponses);
            this.fPreviousResponses = null;
        }
        this.fPreviousCurrentResponse = this.fContext.getCurrentResponse();
        this.fCurrentResult = this.fCurrentResult.getParent();
    }

    private void saveCurrentResponseIfNeeded(BuildEvent event) {
        File file;
        HtmlPage page;
        WebResponse resp;
        if (!this.isSaveResponse()) {
            return;
        }
        String savePrefix = this.getSavePrefix();
        if (this.isNewResponse(event)) {
            if (this.isExceptionWithResponse(event)) {
                Throwable cause = event.getException().getCause();
                resp = cause instanceof FailingHttpStatusCodeException ? ((FailingHttpStatusCodeException)cause).getResponse() : ((ScriptException)cause).getPage().getWebResponse();
            } else {
                resp = this.fContext.getCurrentResponse().getWebResponse();
                if (this.fContext.getCurrentResponse() instanceof HtmlPage) {
                    page = (HtmlPage)this.fContext.getCurrentResponse();
                    page.addDomChangeListener(this.domChangeListener);
                }
            }
            file = this.getResponseFile(resp, savePrefix, this.fCurrentResult.getTaskName());
            ContextHelper.writeResponseFile(resp, file);
        } else if (this.domChangedInLastPage && this.fContext.getCurrentResponse() instanceof HtmlPage) {
            page = (HtmlPage)this.fContext.getCurrentResponse();
            resp = page.getWebResponse();
            file = this.getResponseFile("html", savePrefix, this.fCurrentResult.getTaskName());
            this.writeStringToFile(file, page.asXml());
        } else {
            return;
        }
        File infoFile = new File(file.getParentFile(), file.getName() + ".info");
        LOG.debug((Object)("Writing additional info to " + infoFile));
        StringBuilder sb = new StringBuilder();
        sb.append("url=").append(resp.getWebRequest().getUrl()).append('\n');
        Set cookies = this.fContext.getWebClient().getCookieManager().getCookies();
        sb.append("cookies=").append(cookies.size()).append('\n');
        int i = 0;
        for (Cookie cookie : cookies) {
            String prefix = "cookie." + i++;
            sb.append(prefix).append(".name=").append(cookie.getName()).append('\n');
            sb.append(prefix).append(".domain=").append(cookie.getDomain()).append('\n');
            sb.append(prefix).append(".value=").append(cookie.getValue()).append('\n');
            sb.append(prefix).append(".path=").append(cookie.getPath()).append('\n');
        }
        this.writeStringToFile(infoFile, sb.toString());
        this.fCurrentResult.getAttributes().put("resultFilename", file.getName());
        this.domChangedInLastPage = false;
    }

    private void writeStringToFile(File file, String text) {
        try {
            FileUtils.writeStringToFile((File)file, (String)text, (String)"UTF-8");
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write to file " + file), (Throwable)e);
            throw new RuntimeException("Failed to write reporting data", e);
        }
    }

    private String getSavePrefix() {
        String prefix = this.fCurrentResult.getAttribute("save");
        if (!StringUtils.isEmpty((String)prefix)) {
            return prefix;
        }
        prefix = this.fCurrentResult.getAttribute("savePrefix");
        return StringUtils.defaultIfEmpty((String)prefix, (String)this.fContext.getConfig().getSavePrefix());
    }

    File getResponseFile(String fileExtension, String fileNamePrefix, String fileNameSuffix) {
        int namespaceIndex = fileNameSuffix.indexOf(":");
        File resultDir = this.fContext.getConfig().getWebTestResultDir();
        String prefix = StringUtils.leftPad((String)String.valueOf(++this.resultIndex), (int)3, (char)'0');
        String filename = prefix + "_" + fileNamePrefix + "_" + fileNameSuffix.substring(namespaceIndex == -1 ? 0 : namespaceIndex + 1) + "." + fileExtension;
        return new File(resultDir, filename);
    }

    File getResponseFile(WebResponse response, String fileNamePrefix, String fileNameSuffix) {
        String contentType = response.getContentType();
        contentType = MimeMap.adjustMimeTypeIfNeeded(contentType, response.getWebRequest().getUrl().toString());
        String extension = MimeMap.getExtension(contentType);
        return this.getResponseFile(extension, fileNamePrefix, fileNameSuffix);
    }

    private boolean isExceptionWithResponse(BuildEvent event) {
        if (event.getException() == null) {
            return false;
        }
        Throwable cause = event.getException().getCause();
        if (cause instanceof FailingHttpStatusCodeException) {
            return true;
        }
        if (cause instanceof ScriptException) {
            ScriptException se = (ScriptException)cause;
            return se.getPage() != null;
        }
        return false;
    }

    private boolean isNewResponse(BuildEvent event) {
        LOG.debug((Object)("fPreviousCurrentResponse: " + this.fPreviousCurrentResponse));
        LOG.debug((Object)("fContext.getCurrentResponse(): " + this.fContext.getCurrentResponse()));
        boolean br = this.fPreviousCurrentResponse != this.fContext.getCurrentResponse();
        LOG.debug((Object)("isWorthSaving: " + br + ", " + this.isExceptionWithResponse(event)));
        return this.fContext.getCurrentResponse() != null && this.fPreviousCurrentResponse != this.fContext.getCurrentResponse() || this.isExceptionWithResponse(event);
    }

    private boolean isSaveResponse() {
        String stepSave = this.fCurrentResult.getAttribute("save");
        if (!StringUtils.isEmpty((String)stepSave)) {
            return true;
        }
        String stepSaveResponse = this.fCurrentResult.getAttribute("saveresponse");
        if (!StringUtils.isEmpty((String)stepSaveResponse)) {
            return ConversionUtil.convertToBoolean(stepSaveResponse, false);
        }
        return this.fContext.getConfig().isSaveResponse();
    }

    public void taskStarted(BuildEvent event) {
        if (!this.isEventForMe()) {
            return;
        }
        Task task = event.getTask();
        if (!this.isInteresting(task)) {
            return;
        }
        StepResult result = new StepResult(task);
        if (this.fCurrentResult != null) {
            this.fCurrentResult.addChild(result);
            this.fCurrentResult = result;
        } else {
            this.fRootResult = new RootStepResult((TestStepSequence)task);
            this.fCurrentResult = this.fRootResult;
        }
        this.fPreviousCurrentResponse = this.fContext.getCurrentResponse();
        this.fPreviousResponses = this.fContext.getResponses();
    }

    protected boolean isEventForMe() {
        return this.owningThread == Thread.currentThread();
    }

    public void webtestFinished() {
    }
}

