/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFField;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.List;

public class PdfVerifyFieldStep
extends AbstractVerifyPdfStep {
    private String fName;
    private int fPage = -1;
    private boolean fExists = true;

    public void setPage(int page) {
        this.fPage = page;
    }

    public int getPage() {
        return this.fPage;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setExists(boolean exists) {
        this.fExists = exists;
    }

    public boolean getExists() {
        return this.fExists;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getName(), "name");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        List fields = this.getPage() == -1 ? pdfPage.getFields(this.getName()) : pdfPage.getFields(this.getName(), this.getPage());
        if (this.getExists() == fields.isEmpty()) {
            String msg = "";
            msg = fields.isEmpty() ? "No" : msg + fields.size();
            msg = msg + " field(s) found with name >" + this.getName() + "<";
            if (this.getPage() != -1) {
                msg = msg + " on page " + this.getPage();
            }
            StepFailedException sfe = new StepFailedException(msg);
            List availableFiels = this.getPage() == -1 ? pdfPage.getFields() : pdfPage.getFields(this.getPage());
            if (availableFiels.isEmpty()) {
                sfe.addDetail("available fields", "- none -");
            } else {
                StringBuffer sb = new StringBuffer();
                for (PDFField field : availableFiels) {
                    sb.append(field.getName());
                    sb.append("\n");
                }
                sfe.addDetail("available fields", sb.toString());
            }
            throw sfe;
        }
    }
}

