/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.exceltest.AbstractExcelCellStep;
import com.canoo.webtest.plugins.exceltest.ExcelCellUtils;
import com.canoo.webtest.plugins.exceltest.ExcelColorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.util.CellReference;

public class ExcelVerifyCellStyle
extends AbstractExcelCellStep {
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    private static final String[] SIDES = new String[]{"top", "right", "bottom", "left"};
    private String fType;
    private String fFormat;
    private String fAlign;
    private String fValign;
    private String fWrap;
    private String fLocked;
    private String fFontName;
    private String fFontSize;
    private String fFontStyle;
    private String fBorder;
    private String fBorderColor;
    private String fTextColor;
    private String fFillColor;
    private String fFillBackgroundColor;
    private String fFillPattern;

    public void setFormat(String text) {
        this.fFormat = text;
    }

    public String getFormat() {
        return this.fFormat;
    }

    public void setType(String text) {
        this.fType = text;
    }

    public String getType() {
        return this.fType;
    }

    public void setAlign(String text) {
        this.fAlign = text;
    }

    public String getAlign() {
        return this.fAlign;
    }

    public void setValign(String text) {
        this.fValign = text;
    }

    public String getValign() {
        return this.fValign;
    }

    public void setWrap(String text) {
        this.fWrap = text;
    }

    public String getWrap() {
        return this.fWrap;
    }

    public void setFontStyle(String text) {
        this.fFontStyle = text;
    }

    public String getFontStyle() {
        return this.fFontStyle;
    }

    public void setLocked(String text) {
        this.fLocked = text;
    }

    public String getLocked() {
        return this.fLocked;
    }

    public void setFontName(String text) {
        this.fFontName = text;
    }

    public String getFontName() {
        return this.fFontName;
    }

    public void setFontSize(String text) {
        this.fFontSize = text;
    }

    public String getFontSize() {
        return this.fFontSize;
    }

    public void setBorder(String text) {
        this.fBorder = text;
    }

    public String getBorder() {
        return this.fBorder;
    }

    public void setBorderColor(String text) {
        this.fBorderColor = text;
    }

    public String getBorderColor() {
        return this.fBorderColor;
    }

    public void setTextColor(String text) {
        this.fTextColor = text;
    }

    public String getTextColor() {
        return this.fTextColor;
    }

    public void setFillColor(String text) {
        this.fFillColor = text;
    }

    public String getFillColor() {
        return this.fFillColor;
    }

    public void setFillBackgroundColor(String text) {
        this.fFillBackgroundColor = text;
    }

    public String getFillBackgroundColor() {
        return this.fFillBackgroundColor;
    }

    public void setFillPattern(String text) {
        this.fFillPattern = text;
    }

    public String getFillPattern() {
        return this.fFillPattern;
    }

    public void doExecute() throws Exception {
        String[] border = this.separateSides(this.getBorder());
        String[] borderColor = this.separateSides(this.getBorderColor());
        for (int i = 0; i < SIDES.length; ++i) {
            this.checkFormat(SIDES[i] + "Border", border[i], this.getCellBorder(i));
            this.checkFormat(SIDES[i] + "BorderColor", ExcelColorUtils.lookupStandardColorName(borderColor[i]), this.getCellBorderColor(i));
        }
        HSSFCell excelCell = this.getExcelCell();
        this.checkFormat("type", this.getType(), ExcelCellUtils.getCellType(excelCell == null ? 3 : excelCell.getCellType()));
        if (excelCell == null) {
            if (this.cellNotRequired()) {
                return;
            }
            throw new StepExecutionException("Can't find cell for " + this.getCellReferenceStr(), this);
        }
        HSSFCellStyle cellStyle = excelCell.getCellStyle();
        this.checkFormat("format", this.getFormat(), this.getExcelWorkbook().createDataFormat().getFormat(cellStyle.getDataFormat()));
        this.checkFormat("align", this.getAlign(), ExcelCellUtils.getAlignmentString(cellStyle.getAlignment()));
        this.checkFormat("valign", this.getValign(), ExcelCellUtils.getVerticalAlignmentString(cellStyle.getVerticalAlignment()));
        this.checkFormat("wrap", this.getWrap(), String.valueOf(cellStyle.getWrapText()));
        this.checkFormat("locked", this.getLocked(), String.valueOf(cellStyle.getLocked()));
        this.checkFormat("fontName", this.getFontName(), this.getFont(cellStyle).getFontName());
        this.checkFormat("fontSize", this.getFontSize(), String.valueOf(this.getFont(cellStyle).getFontHeightInPoints()));
        this.checkFormat("fontStyle", ExcelVerifyCellStyle.sortElements(this.getFontStyle()), ExcelVerifyCellStyle.getFontStyle(this.getFont(cellStyle)));
        this.checkFormat("fillColor", ExcelColorUtils.lookupStandardColorName(this.getFillColor()), ExcelColorUtils.getColorName(this, cellStyle.getFillForegroundColor()));
        this.checkFormat("fillBackgroundColor", ExcelColorUtils.lookupStandardColorName(this.getFillBackgroundColor()), ExcelColorUtils.getColorName(this, cellStyle.getFillBackgroundColor()));
        this.checkFormat("textColor", ExcelColorUtils.lookupStandardColorName(this.getTextColor()), ExcelColorUtils.getColorName(this, this.getFont(cellStyle).getColor()));
        this.checkFormat("fillPattern", this.getFillPattern(), ExcelCellUtils.getFillPattern(cellStyle.getFillPattern()));
    }

    private static String sortElements(String elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(elements, " ");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        Collections.sort(list);
        StringBuffer sb = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String getFontStyle(HSSFFont font) {
        StringBuffer sb = new StringBuffer();
        if (font.getBoldweight() == 700) {
            sb.append("bold ");
        }
        if (font.getItalic()) {
            sb.append("italic ");
        }
        if (font.getStrikeout()) {
            sb.append("strikethrough ");
        }
        if (font.getTypeOffset() == 2) {
            sb.append("subscript ");
        } else if (font.getTypeOffset() == 1) {
            sb.append("superscript ");
        }
        switch (font.getUnderline()) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("underline ");
                break;
            }
            case 33: {
                sb.append("underline-accounting ");
                break;
            }
            case 2: {
                sb.append("underline-double ");
                break;
            }
            case 34: {
                sb.append("underline-double-accounting ");
                break;
            }
            default: {
                sb.append("underline-unknown ");
            }
        }
        if (sb.length() == 0) {
            return "normal";
        }
        return sb.substring(0, sb.length() - 1);
    }

    private boolean cellNotRequired() {
        return this.fFormat == null && this.fAlign == null && this.fValign == null && this.fWrap == null && this.fLocked == null && this.fFontName == null && this.fFontSize == null && this.fFontStyle == null && this.fFillColor == null && this.fFillBackgroundColor == null && this.fFillPattern == null && this.fTextColor == null;
    }

    public String getCellBorder(int dir) {
        HSSFCell adjacentCell;
        HSSFCell excelCellAt = this.getExcelCell();
        short border = 0;
        if (excelCellAt != null) {
            border = this.getBorder(excelCellAt.getCellStyle(), dir);
        }
        if (border == 0 && (adjacentCell = this.getAdjacentCell(dir)) != null) {
            border = this.getBorder(adjacentCell.getCellStyle(), (dir + 2) % 4);
        }
        return ExcelCellUtils.getBorder(border);
    }

    public String getCellBorderColor(int dir) {
        HSSFCell adjacentCell;
        HSSFCell excelCellAt = this.getExcelCell();
        short border = 0;
        if (excelCellAt != null) {
            border = this.getBorderColor(excelCellAt.getCellStyle(), dir);
        }
        if (border == 0 && (adjacentCell = this.getAdjacentCell(dir)) != null) {
            border = this.getBorderColor(adjacentCell.getCellStyle(), (dir + 2) % 4);
        }
        return ExcelColorUtils.getColorName(this, border);
    }

    HSSFCell getAdjacentCell(int dir) {
        CellReference cellReference = this.getCellReference();
        int yofs = 0;
        int xofs = 0;
        switch (dir) {
            case 0: {
                yofs = -1;
                break;
            }
            case 1: {
                xofs = 1;
                break;
            }
            case 2: {
                yofs = 1;
                break;
            }
            case 3: {
                xofs = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid side: " + dir);
            }
        }
        return ExcelCellUtils.getExcelCellAt(this, cellReference.getRow() + yofs, (short)(cellReference.getCol() + xofs));
    }

    short getBorder(HSSFCellStyle cellStyle, int index) {
        switch (index) {
            case 0: {
                return cellStyle.getBorderTop();
            }
            case 1: {
                return cellStyle.getBorderRight();
            }
            case 2: {
                return cellStyle.getBorderBottom();
            }
            case 3: {
                return cellStyle.getBorderLeft();
            }
        }
        throw new IllegalArgumentException("Invalid side: " + index);
    }

    short getBorderColor(HSSFCellStyle cellStyle, int index) {
        switch (index) {
            case 0: {
                return cellStyle.getTopBorderColor();
            }
            case 1: {
                return cellStyle.getRightBorderColor();
            }
            case 2: {
                return cellStyle.getBottomBorderColor();
            }
            case 3: {
                return cellStyle.getLeftBorderColor();
            }
        }
        throw new IllegalArgumentException("Invalid side: " + index);
    }

    private HSSFFont getFont(HSSFCellStyle cellStyle) {
        return this.getExcelWorkbook().getFontAt(cellStyle.getFontIndex());
    }

    private void checkFormat(String property, String expected, String actual) {
        if (expected == null || this.verifyStrings(expected, actual)) {
            return;
        }
        throw new StepFailedException("Wrong cell style found for property '" + property + "' in cell " + this.getCellReferenceStr(), expected, actual, this);
    }

    private String[] separateSides(String border) {
        String[] result = new String[SIDES.length];
        if (border != null) {
            StringTokenizer st = new StringTokenizer(border, ";");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int colon = s.indexOf(58);
                if (colon != -1) {
                    String sides = s.substring(0, colon);
                    String value = s.substring(colon + 1).trim();
                    StringTokenizer st2 = new StringTokenizer(sides, ",");
                    while (st2.hasMoreTokens()) {
                        int i;
                        String side = st2.nextToken().trim();
                        for (i = 0; i < SIDES.length; ++i) {
                            if (!side.equals(SIDES[i])) continue;
                            result[i] = value;
                            break;
                        }
                        if (i != SIDES.length) continue;
                        throw new StepExecutionException("Border side '" + side + "' unknown.  Specify one of top, down, left right.", this);
                    }
                    continue;
                }
                for (int i = 0; i < SIDES.length; ++i) {
                    result[i] = s;
                }
            }
        }
        return result;
    }
}

