/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.SelectorUtils;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class WagonDirectoryScanner {
    public static final String[] DEFAULTEXCLUDES = DirectoryScanner.DEFAULTEXCLUDES;
    private Wagon wagon;
    private String directory;
    private String[] includes;
    private String[] excludes;
    private boolean isCaseSensitive = true;
    private List filesIncluded = new ArrayList();
    private Log logger;

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                String pattern = includes[i].trim();
                if (pattern.endsWith("/")) {
                    pattern = pattern + "**";
                }
                this.includes[i] = pattern;
            }
        }
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                String pattern = excludes[i].trim();
                if (pattern.endsWith("/")) {
                    pattern = pattern + "**";
                }
                this.excludes[i] = pattern;
            }
        }
    }

    private boolean isIncluded(String name) {
        for (String include : this.includes) {
            if (!WagonDirectoryScanner.matchPath(include, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        for (String exclude : this.excludes) {
            if (!WagonDirectoryScanner.matchPath(exclude, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        for (String include : this.includes) {
            if (!WagonDirectoryScanner.matchPatternStart(include, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    private static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public void scan() throws WagonException {
        if (this.wagon == null) {
            throw new IllegalStateException("No wagon set");
        }
        if (StringUtils.isBlank((String)this.directory)) {
            this.directory = "";
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new ArrayList();
        this.scandir(this.directory, "");
        Collections.sort(this.filesIncluded);
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        System.arraycopy(DEFAULTEXCLUDES, 0, newExcludes, excludesLength, DEFAULTEXCLUDES.length);
        this.excludes = newExcludes;
    }

    private boolean isRidiculousFile(String fileName) {
        return fileName.endsWith(".") || fileName.contains("*") || fileName.startsWith("?") || fileName.startsWith("#");
    }

    private void scandir(String dir, String vpath) throws WagonException {
        this.logger.debug((CharSequence)("scandir: dir: " + dir + " vpath: " + vpath));
        List files = this.wagon.getFileList(dir);
        for (Object file1 : files) {
            String fileName = (String)file1;
            if (this.isRidiculousFile(fileName)) continue;
            String file = fileName;
            if (!StringUtils.isBlank((String)dir)) {
                file = dir.endsWith("/") ? dir + fileName : dir + "/" + fileName;
            }
            String name = vpath + fileName;
            if (this.isDirectory(file)) {
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        this.scandir(file, name);
                        continue;
                    }
                    if (!this.couldHoldIncluded(name)) continue;
                    this.scandir(file, name);
                    continue;
                }
                if (!this.couldHoldIncluded(name)) continue;
                this.scandir(file, name);
                continue;
            }
            if (!this.isIncluded(name) || this.isExcluded(name)) continue;
            this.filesIncluded.add(name);
        }
    }

    private boolean isDirectory(String existedRemotePath) {
        if (existedRemotePath.endsWith("/")) {
            return true;
        }
        return this.canListPath(existedRemotePath + "/");
    }

    private boolean canListPath(String remotePath) {
        try {
            List resources = this.wagon.getFileList(remotePath);
            return resources != null && !resources.isEmpty();
        }
        catch (WagonException e) {
            return false;
        }
    }

    public List getFilesIncluded() {
        return this.filesIncluded;
    }

    public void setWagon(Wagon wagon) {
        this.wagon = wagon;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setDirectory(String basePath) {
        this.directory = basePath;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }
}

