/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.AbstractSingleWagonMojo;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="upload")
public class UploadMojo
extends AbstractSingleWagonMojo {
    @Parameter(property="wagon.fromDir", defaultValue="${project.basedir}")
    private File fromDir;
    @Parameter(property="wagon.excludes")
    private String excludes;
    @Parameter(property="wagon.includes")
    private String includes;
    @Parameter(property="wagon.followSymLink", defaultValue="false")
    private boolean followSymLink = false;
    @Parameter(property="wagon.useDefaultExcludes", defaultValue="true")
    private boolean useDefaultExcludes = true;
    @Parameter(property="wagon.toDir")
    private String toDir = "";
    @Parameter(property="wagon.optimize", defaultValue="false")
    private boolean optimize = false;
    @Component
    protected WagonUpload wagonUpload;

    @Override
    protected void execute(Wagon wagon) throws WagonException, IOException {
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(this.fromDir.getAbsolutePath());
        if (!StringUtils.isBlank((String)this.includes)) {
            fileSet.setIncludes(Arrays.asList(StringUtils.split((String)this.includes, (String)",")));
        }
        if (!StringUtils.isBlank((String)this.excludes)) {
            fileSet.setExcludes(Arrays.asList(StringUtils.split((String)this.excludes, (String)",")));
        }
        fileSet.setFollowSymlinks(this.followSymLink);
        fileSet.setUseDefaultExcludes(this.useDefaultExcludes);
        fileSet.setOutputDirectory(this.toDir);
        this.wagonUpload.upload(wagon, fileSet, this.optimize, this.getLog());
    }
}

