/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="display-dependency-updates", requiresProject=true, requiresDirectInvocation=false, threadSafe=true)
public class DisplayDependencyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int INFO_PAD_SIZE = 72;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies;
    @Parameter(property="processPluginDependencies", defaultValue="true")
    private boolean processPluginDependencies;
    @Parameter(property="processPluginDependenciesInPluginManagement", defaultValue="true")
    private boolean processPluginDependenciesInPluginManagement;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    @Parameter(property="allowAnyUpdates", defaultValue="true")
    private boolean allowAnyUpdates;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;

    private static Set<Dependency> extractPluginDependenciesFromPluginsInPluginManagement(Build build) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(new DependencyComparator());
        if (build.getPluginManagement() != null) {
            for (Plugin plugin : build.getPluginManagement().getPlugins()) {
                if (plugin.getDependencies() == null || plugin.getDependencies().isEmpty()) continue;
                result.addAll(plugin.getDependencies());
            }
        }
        return result;
    }

    private static Set<Dependency> extractDependenciesFromPlugins(List<Plugin> plugins) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(new DependencyComparator());
        for (Plugin plugin : plugins) {
            if (plugin.getDependencies() == null || plugin.getDependencies().isEmpty()) continue;
            result.addAll(plugin.getDependencies());
        }
        return result;
    }

    private static Set<Dependency> removeDependencyManagment(Set<Dependency> dependencies, Set<Dependency> dependencyManagement) {
        TreeSet<Dependency> result = new TreeSet<Dependency>(new DependencyComparator());
        for (Dependency dependency : dependencies) {
            boolean matched = false;
            for (Dependency managedDependency : dependencyManagement) {
                if (!DisplayDependencyUpdatesMojo.dependenciesMatch(dependency, managedDependency)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            result.add(dependency);
        }
        return result;
    }

    protected static boolean dependenciesMatch(Dependency dependency, Dependency managedDependency) {
        if (!managedDependency.getGroupId().equals(dependency.getGroupId())) {
            return false;
        }
        if (!managedDependency.getArtifactId().equals(dependency.getArtifactId())) {
            return false;
        }
        if (managedDependency.getScope() == null || Objects.equals(managedDependency.getScope(), dependency.getScope())) {
            return false;
        }
        if (managedDependency.getClassifier() == null || Objects.equals(managedDependency.getClassifier(), dependency.getClassifier())) {
            return false;
        }
        return dependency.getVersion() == null || managedDependency.getVersion() == null || Objects.equals(managedDependency.getVersion(), dependency.getVersion());
    }

    public boolean isProcessingDependencyManagement() {
        return this.processDependencyManagement;
    }

    public boolean isProcessingDependencies() {
        return this.processDependencies;
    }

    public boolean isProcessingPluginDependencies() {
        return this.processPluginDependencies;
    }

    public boolean isProcessPluginDependenciesInDependencyManagement() {
        return this.processPluginDependenciesInPluginManagement;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInit();
        TreeSet<Dependency> dependencyManagement = new TreeSet<Dependency>(new DependencyComparator());
        if (this.getProject().getDependencyManagement() != null) {
            List dependenciesFromPom = this.getProject().getDependencyManagement().getDependencies();
            for (Dependency dependency : dependenciesFromPom) {
                this.getLog().debug((CharSequence)("dependency from pom: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion()));
                if (dependency.getVersion() == null) {
                    if (this.getProject().hasParent()) {
                        this.getLog().debug((CharSequence)"Reading parent dependencyManagement information");
                        if (this.getProject().getParent().getDependencyManagement() == null) continue;
                        List parentDeps = this.getProject().getParent().getDependencyManagement().getDependencies();
                        for (Dependency parentDep : parentDeps) {
                            if (!dependency.getGroupId().equals(parentDep.getGroupId()) || !dependency.getArtifactId().equals(parentDep.getArtifactId()) || !dependency.getType().equals(parentDep.getType())) continue;
                            dependencyManagement.add(parentDep);
                        }
                        continue;
                    }
                    String message = "We can't get the version for the dependency " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " cause there does not exist a parent.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
                dependencyManagement.add(dependency);
            }
        }
        Set<Dependency> dependencies = new TreeSet<Dependency>(new DependencyComparator());
        dependencies.addAll(this.getProject().getDependencies());
        if (this.isProcessingDependencyManagement()) {
            dependencies = DisplayDependencyUpdatesMojo.removeDependencyManagment(dependencies, dependencyManagement);
        }
        Set<Dependency> pluginDependencies = new TreeSet<Dependency>(new DependencyComparator());
        if (this.isProcessingPluginDependencies()) {
            pluginDependencies = DisplayDependencyUpdatesMojo.extractDependenciesFromPlugins(this.getProject().getBuildPlugins());
        }
        Set<Dependency> pluginDependenciesInPluginManagement = new TreeSet<Dependency>(new DependencyComparator());
        if (this.isProcessPluginDependenciesInDependencyManagement()) {
            pluginDependenciesInPluginManagement = DisplayDependencyUpdatesMojo.extractPluginDependenciesFromPluginsInPluginManagement(this.getProject().getBuild());
        }
        try {
            if (this.isProcessingDependencyManagement()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencyManagement, false), "Dependency Management");
            }
            if (this.isProcessingDependencies()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencies, false), "Dependencies");
            }
            if (this.isProcessPluginDependenciesInDependencyManagement()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(pluginDependenciesInPluginManagement, false), "pluginManagement of plugins");
            }
            if (this.isProcessingPluginDependencies()) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(pluginDependencies, false), "Plugin Dependencies");
            }
        }
        catch (ArtifactMetadataRetrievalException | InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private UpdateScope calculateUpdateScope() {
        UpdateScope result = UpdateScope.ANY;
        if (!this.allowAnyUpdates) {
            if (this.allowMajorUpdates) {
                result = UpdateScope.MAJOR;
            } else if (this.allowMinorUpdates) {
                result = UpdateScope.MINOR;
            } else if (this.allowIncrementalUpdates) {
                result = UpdateScope.INCREMENTAL;
            }
        }
        return result;
    }

    private void logUpdates(Map<Dependency, ArtifactVersions> updates, String section) {
        Iterator<ArtifactVersions> i;
        ArrayList withUpdates = new ArrayList();
        ArrayList<String> usingCurrent = new ArrayList<String>();
        for (ArtifactVersions versions : updates.values()) {
            ArrayList<String> t;
            ArtifactVersion latest;
            String current;
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            if (versions.isCurrentVersionDefined()) {
                current = versions.getCurrentVersion().toString();
                latest = versions.getNewestUpdate(this.calculateUpdateScope(), this.allowSnapshots);
            } else {
                ArtifactVersion newestVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), this.allowSnapshots);
                current = versions.getArtifact().getVersionRange().toString();
                ArtifactVersion artifactVersion = latest = newestVersion == null ? null : versions.getNewestUpdate(newestVersion, this.calculateUpdateScope(), this.allowSnapshots);
                if (latest != null && ArtifactVersions.isVersionInRange(latest, versions.getArtifact().getVersionRange())) {
                    latest = null;
                }
            }
            String right = " " + (latest == null ? current : current + " -> " + latest);
            ArrayList<String> arrayList = t = latest == null ? usingCurrent : withUpdates;
            if (right.length() + left.length() + 3 > 72) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)72));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(72 - right.length()), (String)".") + right);
        }
        if (this.isVerbose()) {
            if (usingCurrent.isEmpty()) {
                if (!withUpdates.isEmpty()) {
                    this.logLine(false, "No dependencies in " + section + " are using the newest version.");
                    this.logLine(false, "");
                }
            } else {
                this.logLine(false, "The following dependencies in " + section + " are using the newest version:");
                i = usingCurrent.iterator();
                while (i.hasNext()) {
                    this.logLine(false, (String)((Object)i.next()));
                }
                this.logLine(false, "");
            }
        }
        if (withUpdates.isEmpty()) {
            if (!usingCurrent.isEmpty()) {
                this.logLine(false, "No dependencies in " + section + " have newer versions.");
                this.logLine(false, "");
            }
        } else {
            this.logLine(false, "The following dependencies in " + section + " have newer versions:");
            i = withUpdates.iterator();
            while (i.hasNext()) {
                this.logLine(false, (String)((Object)i.next()));
            }
            this.logLine(false, "");
        }
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }
}

