/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.api.VersionDetails;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public abstract class AbstractVersionDetails
implements VersionDetails {
    private ArtifactVersion currentVersion = null;
    private boolean includeSnapshots = false;
    private final Object currentVersionLock = new Object();

    protected AbstractVersionDetails() {
    }

    protected AbstractVersionDetails(ArtifactVersion currentVersion, boolean includeSnapshots) {
        this.currentVersion = currentVersion;
        this.includeSnapshots = includeSnapshots;
    }

    public final boolean isCurrentVersionDefined() {
        return this.getCurrentVersion() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArtifactVersion getCurrentVersion() {
        Object object = this.currentVersionLock;
        synchronized (object) {
            return this.currentVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCurrentVersion(ArtifactVersion currentVersion) {
        Object object = this.currentVersionLock;
        synchronized (object) {
            this.currentVersion = currentVersion;
        }
    }

    public final void setCurrentVersion(String currentVersion) {
        this.setCurrentVersion((ArtifactVersion)(currentVersion == null ? null : new DefaultArtifactVersion(currentVersion)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isIncludeSnapshots() {
        Object object = this.currentVersionLock;
        synchronized (object) {
            return this.includeSnapshots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIncludeSnapshots(boolean includeSnapshots) {
        Object object = this.currentVersionLock;
        synchronized (object) {
            this.includeSnapshots = includeSnapshots;
        }
    }

    public final ArtifactVersion[] getVersions() {
        return this.getVersions(this.isIncludeSnapshots());
    }

    public abstract ArtifactVersion[] getVersions(boolean var1);

    public final ArtifactVersion[] getVersions(VersionRange versionRange, boolean includeSnapshots) {
        return this.getVersions(versionRange, null, null, includeSnapshots, true, true);
    }

    public final ArtifactVersion[] getVersions(ArtifactVersion currentVersion, ArtifactVersion upperBound) {
        return this.getVersions(currentVersion, upperBound, this.isIncludeSnapshots());
    }

    public final ArtifactVersion[] getVersions(ArtifactVersion currentVersion, ArtifactVersion upperBound, boolean includeSnapshots) {
        return this.getVersions(currentVersion, upperBound, includeSnapshots, false, false);
    }

    private final ArtifactVersion[] getNewerVersions(ArtifactVersion version, int upperBoundFixedSegment, boolean includeSnapshots) {
        ArtifactVersion lowerBound = version;
        ArtifactVersion upperBound = null;
        if (upperBoundFixedSegment != -1) {
            upperBound = this.getVersionComparator().incrementSegment(lowerBound, upperBoundFixedSegment);
        }
        return this.getVersions(version, upperBound, includeSnapshots, false, false);
    }

    private final ArtifactVersion[] getNewerVersions(ArtifactVersion version, boolean includeSnapshots) {
        return this.getVersions(version, null, includeSnapshots, false, true);
    }

    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound) {
        return this.getNewestVersion(lowerBound, upperBound, this.isIncludeSnapshots());
    }

    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots) {
        return this.getNewestVersion(lowerBound, upperBound, includeSnapshots, false, false);
    }

    public final ArtifactVersion getNewestVersion(VersionRange versionRange, ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        ArtifactVersion latest = null;
        VersionComparator versionComparator = this.getVersionComparator();
        Iterator<ArtifactVersion> i = Arrays.asList(this.getVersions(includeSnapshots)).iterator();
        while (i.hasNext()) {
            int upper;
            ArtifactVersion candidate = i.next();
            if (versionRange != null && !ArtifactVersions.isVersionInRange(candidate, versionRange)) continue;
            int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
            int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
            if (lower > 0 || upper < 0 || !includeLower && lower == 0 || !includeUpper && upper == 0 || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            if (latest == null) {
                latest = candidate;
                continue;
            }
            if (versionComparator.compare(latest, candidate) >= 0) continue;
            latest = candidate;
        }
        return latest;
    }

    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        return this.getNewestVersion(null, lowerBound, upperBound, includeSnapshots, includeLower, includeUpper);
    }

    public final ArtifactVersion getNewestVersion(VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, null, null, includeSnapshots, true, true);
    }

    public final boolean containsVersion(String version) {
        Iterator<ArtifactVersion> i = Arrays.asList(this.getVersions(true)).iterator();
        while (i.hasNext()) {
            ArtifactVersion candidate = i.next();
            if (!version.equals(candidate.toString())) continue;
            return true;
        }
        return false;
    }

    public final ArtifactVersion[] getNewerVersions(String version, boolean includeSnapshots) {
        return this.getNewerVersions((ArtifactVersion)new DefaultArtifactVersion(version), includeSnapshots);
    }

    public final ArtifactVersion[] getNewerVersions(String version, int upperBoundSegment, boolean includeSnapshots) {
        return this.getNewerVersions((ArtifactVersion)new DefaultArtifactVersion(version), upperBoundSegment, includeSnapshots);
    }

    public final ArtifactVersion getOldestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound) {
        return this.getOldestVersion(lowerBound, upperBound, true);
    }

    public final ArtifactVersion getOldestVersion(VersionRange versionRange, boolean includeSnapshots) {
        return this.getOldestVersion(versionRange, null, null, includeSnapshots, true, true);
    }

    public final ArtifactVersion getOldestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots) {
        return this.getOldestVersion(lowerBound, upperBound, includeSnapshots, false, false);
    }

    public final ArtifactVersion getOldestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        return this.getOldestVersion(null, lowerBound, upperBound, includeSnapshots, includeLower, includeUpper);
    }

    public final ArtifactVersion getOldestVersion(VersionRange versionRange, ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        ArtifactVersion oldest = null;
        VersionComparator versionComparator = this.getVersionComparator();
        Iterator<ArtifactVersion> i = Arrays.asList(this.getVersions(includeSnapshots)).iterator();
        while (i.hasNext()) {
            int upper;
            ArtifactVersion candidate = i.next();
            if (versionRange != null && !ArtifactVersions.isVersionInRange(candidate, versionRange)) continue;
            int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
            int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
            if (lower > 0 || upper < 0 || !includeLower && lower == 0 || !includeUpper && upper == 0 || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            if (oldest == null) {
                oldest = candidate;
                continue;
            }
            if (versionComparator.compare(oldest, candidate) <= 0) continue;
            oldest = candidate;
        }
        return oldest;
    }

    public final ArtifactVersion[] getVersions(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        return this.getVersions(null, lowerBound, upperBound, includeSnapshots, includeLower, includeUpper);
    }

    public final ArtifactVersion[] getVersions(VersionRange versionRange, ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        VersionComparator versionComparator = this.getVersionComparator();
        TreeSet<ArtifactVersion> result = new TreeSet<ArtifactVersion>(versionComparator);
        Iterator<ArtifactVersion> i = Arrays.asList(this.getVersions(includeSnapshots)).iterator();
        while (i.hasNext()) {
            int upper;
            ArtifactVersion candidate = i.next();
            if (versionRange != null && !ArtifactVersions.isVersionInRange(candidate, versionRange)) continue;
            int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
            int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
            if (lower > 0 || upper < 0 || !includeLower && lower == 0 || !includeUpper && upper == 0 || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            result.add(candidate);
        }
        return result.toArray(new ArtifactVersion[result.size()]);
    }

    public final ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope) {
        return this.getOldestUpdate(currentVersion, updateScope, this.isIncludeSnapshots());
    }

    public final ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope) {
        return this.getNewestUpdate(currentVersion, updateScope, this.isIncludeSnapshots());
    }

    public final ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, UpdateScope updateScope) {
        return this.getAllUpdates(currentVersion, updateScope, this.isIncludeSnapshots());
    }

    public ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, VersionRange versionRange) {
        return this.getOldestUpdate(currentVersion, versionRange, this.isIncludeSnapshots());
    }

    public ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, VersionRange versionRange) {
        return this.getNewestUpdate(currentVersion, versionRange, this.isIncludeSnapshots());
    }

    public ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, VersionRange versionRange) {
        return this.getAllUpdates(currentVersion, versionRange, this.isIncludeSnapshots());
    }

    public final ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope, boolean includeSnapshots) {
        return updateScope.getOldestUpdate(this, currentVersion, includeSnapshots);
    }

    public final ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope, boolean includeSnapshots) {
        return updateScope.getNewestUpdate(this, currentVersion, includeSnapshots);
    }

    public final ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, UpdateScope updateScope, boolean includeSnapshots) {
        return updateScope.getAllUpdates(this, currentVersion, includeSnapshots);
    }

    public ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, VersionRange versionRange, boolean includeSnapshots) {
        return this.getOldestVersion(versionRange, includeSnapshots);
    }

    public ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, includeSnapshots);
    }

    public ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, VersionRange versionRange, boolean includeSnapshots) {
        return new ArtifactVersion[0];
    }

    public final ArtifactVersion getOldestUpdate(UpdateScope updateScope) {
        return this.getOldestUpdate(updateScope, this.isIncludeSnapshots());
    }

    public final ArtifactVersion getNewestUpdate(UpdateScope updateScope) {
        return this.getNewestUpdate(updateScope, this.isIncludeSnapshots());
    }

    public final ArtifactVersion[] getAllUpdates(UpdateScope updateScope) {
        return this.getAllUpdates(updateScope, this.isIncludeSnapshots());
    }

    public final ArtifactVersion getOldestUpdate(UpdateScope updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getOldestUpdate(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    public final ArtifactVersion getNewestUpdate(UpdateScope updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getNewestUpdate(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    public final ArtifactVersion[] getAllUpdates(UpdateScope updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getAllUpdates(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    public final ArtifactVersion getOldestUpdate(VersionRange versionRange) {
        return this.getOldestUpdate(versionRange, this.isIncludeSnapshots());
    }

    public final ArtifactVersion getNewestUpdate(VersionRange versionRange) {
        return this.getNewestUpdate(versionRange, this.isIncludeSnapshots());
    }

    public final ArtifactVersion[] getAllUpdates(VersionRange versionRange) {
        return this.getAllUpdates(versionRange, this.isIncludeSnapshots());
    }

    public ArtifactVersion getOldestUpdate(VersionRange versionRange, boolean includeSnapshots) {
        return this.getOldestVersion(versionRange, this.getCurrentVersion(), null, includeSnapshots, false, true);
    }

    public ArtifactVersion getNewestUpdate(VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, this.getCurrentVersion(), null, includeSnapshots, false, true);
    }

    public ArtifactVersion[] getAllUpdates(VersionRange versionRange, boolean includeSnapshots) {
        return this.getVersions(versionRange, this.getCurrentVersion(), null, includeSnapshots, false, true);
    }
}

