/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.mojo.truezip.FileItem;
import org.codehaus.mojo.truezip.TrueZip;
import org.codehaus.mojo.truezip.internal.DefaultTrueZip;
import org.codehaus.mojo.truezip.internal.DefaultTrueZipArchiveDetector;

public abstract class AbstractArchiveMojo
extends AbstractMojo {
    protected MavenProject project;
    protected TrueZip truezip = new DefaultTrueZip();
    protected boolean immediateUpdate;

    protected String resolveRelativePath(String path) {
        if (path != null && !new TFile(path).isAbsolute()) {
            path = new TFile(this.project.getBasedir(), path).getAbsolutePath();
        }
        return path;
    }

    protected void resolveRelativePath(FileSet fileSet) {
        fileSet.setDirectory(this.resolveRelativePath(fileSet.getDirectory()));
        fileSet.setOutputDirectory(this.resolveRelativePath(fileSet.getOutputDirectory()));
    }

    protected void resolveRelativePath(FileItem fileItem) {
        fileItem.setOutputDirectory(this.resolveRelativePath(fileItem.getOutputDirectory()));
        fileItem.setSource(this.resolveRelativePath(fileItem.getSource()));
    }

    protected void tryImmediateUpdate() throws MojoExecutionException {
        if (this.immediateUpdate) {
            try {
                this.truezip.sync();
            }
            catch (FsSyncException e) {
                throw new MojoExecutionException("Immediate file update failed!", (Exception)((Object)e));
            }
        }
    }

    protected void intitializeArchiveDectector() {
        DefaultTrueZipArchiveDetector archiveDetector = new DefaultTrueZipArchiveDetector();
        archiveDetector.init();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
    }
}

