/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import de.schlichtherle.truezip.file.TFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.truezip.AbstractManipulateArchiveMojo;
import org.codehaus.mojo.truezip.FileItem;
import org.codehaus.mojo.truezip.Fileset;
import org.codehaus.plexus.util.StringUtils;

public class CopyMojo
extends AbstractManipulateArchiveMojo {
    private FileItem[] files;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.processFileItems();
        this.processFileSets();
        this.tryImmediateUpdate();
    }

    private void processFileSets() throws MojoExecutionException, MojoFailureException {
        if (this.fileset != null) {
            this.filesets.add(this.fileset);
            this.fileset = null;
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            Fileset fileSet = (Fileset)((Object)this.filesets.get(i));
            if (StringUtils.isBlank((String)fileSet.getDirectory())) {
                fileSet.setDirectory(this.project.getBasedir().getAbsolutePath());
            }
            try {
                this.resolveRelativePath(fileSet);
                this.truezip.copy(fileSet, this.verbose, this.getLog());
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Copy fileset fails", e);
            }
        }
    }

    private void processFileItems() throws MojoExecutionException, MojoFailureException {
        for (int i = 0; this.files != null && i < this.files.length; ++i) {
            FileItem copyInfo = this.files[i];
            this.resolveRelativePath(copyInfo);
            TFile source = new TFile(copyInfo.getSource());
            TFile dest = new TFile(copyInfo.getDestinationPath());
            try {
                this.truezip.copyFile(source, dest);
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Copy fileset fails", e);
            }
        }
    }
}

