/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sonar.ServerMetadata;

public class Bootstraper {
    public static final String REPOSITORY_ID = "sonar";
    private ServerMetadata server;
    private PluginManager pluginManager;
    private ArtifactRepositoryFactory repoFactory;

    public Bootstraper(ServerMetadata server, ArtifactRepositoryFactory repoFactory, PluginManager pluginManager) {
        this.server = server;
        this.repoFactory = repoFactory;
        this.pluginManager = pluginManager;
    }

    public void start(MavenProject project, MavenSession session) throws IOException, MojoExecutionException {
        this.configure(project);
        this.executeMojo(project, session);
    }

    private void executeMojo(MavenProject project, MavenSession session) throws MojoExecutionException {
        try {
            PluginDescriptor pluginDescriptor = this.pluginManager.verifyPlugin(this.createSonarPlugin(), project, session.getSettings(), session.getLocalRepository());
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo("internal");
            if (mojoDescriptor == null) {
                throw new MojoExecutionException("Unknown mojo goal: install");
            }
            this.pluginManager.executeMojo(project, new MojoExecution(mojoDescriptor), session);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can not execute Sonar", e);
        }
    }

    private void configure(MavenProject project) throws IOException {
        this.configureRepositories(project);
    }

    private void configureRepositories(MavenProject project) throws IOException {
        ArrayList<ArtifactRepository> pluginRepositories = new ArrayList<ArtifactRepository>();
        ArtifactRepository repository = this.createSonarRepository(this.repoFactory);
        pluginRepositories.add(repository);
        pluginRepositories.addAll(project.getPluginArtifactRepositories());
        project.setPluginArtifactRepositories(pluginRepositories);
        ArrayList<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>();
        artifactRepositories.add(repository);
        artifactRepositories.addAll(project.getRemoteArtifactRepositories());
        project.setRemoteArtifactRepositories(artifactRepositories);
    }

    private Plugin createSonarPlugin() throws IOException {
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.codehaus.sonar.runtime");
        plugin.setArtifactId("sonar-core-maven-plugin");
        plugin.setVersion(this.server.getKey());
        return plugin;
    }

    private ArtifactRepository createSonarRepository(ArtifactRepositoryFactory repoFactory) {
        return repoFactory.createArtifactRepository(REPOSITORY_ID, this.server.getMavenRepositoryUrl(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(false, "never", "ignore"), new ArtifactRepositoryPolicy(true, "never", "ignore"));
    }
}

