/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.smc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import net.sf.smc.Smc;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringOutputStream;

public class Util {
    static List getSmFiles(File sourceDirectory) throws IOException {
        return FileUtils.getFiles((File)sourceDirectory, (String)"**/*.sm", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getSmFileHeader(File smFile) throws IOException {
        Properties properties = new Properties();
        FileReader fileReader = new FileReader(smFile);
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("%class ")) {
                    properties.setProperty("class", line.substring("%class ".length()));
                    continue;
                }
                if (!line.startsWith("%package ")) continue;
                properties.setProperty("package", line.substring("%package ".length()));
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStream stream, String outputFilePath) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(stream);
        OutputStream os = null;
        try {
            int read;
            os = new FileOutputStream(new File(outputFilePath));
            byte[] b = new byte[1024];
            while ((read = is.read(b)) != -1) {
                os.write(b, 0, read);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    static void executeSmc(List arguments, Log log) throws Exception {
        StringOutputStream out = new StringOutputStream();
        StringOutputStream err = new StringOutputStream();
        Util.executeSmc(arguments, (OutputStream)out, (OutputStream)err);
        if (out.toString().length() > 0) {
            log.info((CharSequence)out.toString());
        }
        if (err.toString().length() > 0) {
            log.error((CharSequence)(".sm file contains errors: \n" + err.toString()));
            throw new Exception("Error while converting files.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void executeSmc(List arguments, OutputStream out, OutputStream err) {
        PrintStream oldOut = System.out;
        PrintStream newOut = new PrintStream(out);
        System.setErr(newOut);
        PrintStream oldErr = System.err;
        PrintStream newErr = new PrintStream(err);
        System.setErr(newErr);
        try {
            Smc.main((String[])arguments.toArray(new String[arguments.size()]));
        }
        finally {
            System.setErr(oldErr);
            System.setOut(oldOut);
        }
    }
}

