/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pde.descriptor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;

public class ManifestBean {
    private String id;
    private String version;

    public ManifestBean(File dir) {
        this.load(dir);
    }

    private void load(File dir) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(new File(dir, "META-INF/MANIFEST.MF")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            do {
                if ((line = reader.readLine()) == null) continue;
                lines.add(line);
            } while (line != null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.id = this.getValue("Bundle-SymbolicName:", lines);
        this.version = this.getValue("Bundle-Version:", lines);
    }

    private String getValue(String key, ArrayList lines) {
        String retValue = null;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i).toString();
            if (!line.startsWith(key) || (retValue = line.substring(key.length())).indexOf(";") == -1) continue;
            retValue = retValue.substring(0, retValue.indexOf(";"));
        }
        if (retValue != null) {
            retValue = retValue.trim();
        }
        return retValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String theId) {
        this.id = theId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String theVersion) {
        this.version = theVersion;
    }
}

