/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlWriter {
    public static final String START_ELEMENT = "<";
    public static final String START_CLOSE_ELEMENT = "</";
    public static final String END_CLOSE_ELEMENT = "/>";
    public static final String END_ELEMENT = ">";
    public static final String HEADER_TEXT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static String RETURN_CHAR = "\n";
    public static final String TAB_CHAR = "\t";
    public static final String QUOTE = "\"";
    public static final String EQUALS = "=";
    public static final String SPACE = " ";
    public static final String WINDOWS_FAMILY = "windows";
    public static final String LINUX_FAMILY = "linux";
    public static final String SOLARIS_FAMILY = "sunos";
    public static final String UNKNOWN_FAMILY = "other";
    public static final String[] OS_FAMILIES = new String[]{"windows", "linux", "sunos"};
    private FileOutputStream m_outstream;
    private OutputStreamWriter m_writer;
    private boolean m_formatXml = true;
    private HashMap m_attributesOnSameLine = new HashMap();
    private HashMap m_attributeOrder = new HashMap();
    private String m_tabs = "";
    private boolean m_writeEmptyValues = false;
    private boolean m_defaultToAttributesOnSameLine = false;

    public XmlWriter() {
        this(true);
    }

    public XmlWriter(boolean formatXml) {
        this.m_formatXml = formatXml;
        if (XmlWriter.getOsFamily().equals(WINDOWS_FAMILY)) {
            RETURN_CHAR = "\r\n";
        }
    }

    public void setDefaultToAttributesOnSameLine(boolean value) {
        this.m_defaultToAttributesOnSameLine = value;
    }

    public void setAttributesOnSameLine(String nodeName, boolean attributesOnSameLine) {
        this.m_attributesOnSameLine.put(nodeName, new Boolean(attributesOnSameLine));
    }

    public void setAttributeOrder(String nodeName, String[] attributeOrder) {
        this.m_attributeOrder.put(nodeName, attributeOrder);
    }

    public void setWriteEmptyValues(boolean writeEmptyValues) {
        this.m_writeEmptyValues = writeEmptyValues;
    }

    public void saveXmlFile(String filePath, Document xmlDoc) throws IOException {
        if (xmlDoc != null) {
            this.m_outstream = new FileOutputStream(filePath);
            this.m_writer = new OutputStreamWriter((OutputStream)this.m_outstream, "UTF-8");
            this.startXmlDoc();
            Element root = xmlDoc.getDocumentElement();
            this.writeElement(root);
            this.endXmlDoc();
        }
    }

    private void writeElement(Node element) throws IOException {
        int i;
        if (element.getNodeType() != 1) {
            return;
        }
        NamedNodeMap attributeMap = element.getAttributes();
        boolean hasChildren = false;
        NodeList childNodes = element.getChildNodes();
        for (i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            hasChildren = true;
            break;
        }
        if (hasChildren) {
            this.openElement(element.getNodeName(), attributeMap);
            for (i = 0; i < childNodes.getLength(); ++i) {
                this.writeElement(childNodes.item(i));
            }
            this.closeElement(element.getNodeName());
        } else {
            String value = null;
            for (int i2 = 0; i2 < childNodes.getLength(); ++i2) {
                Node node = childNodes.item(i2);
                if (node.getNodeType() != 3) continue;
                value = node.getNodeValue();
                break;
            }
            if (value == null) {
                this.addElementNoValue(element.getNodeName(), attributeMap);
            } else {
                this.addElementAndValue(element.getNodeName(), value, attributeMap);
            }
        }
    }

    private void addElementAndValue(String nodeName, String value, NamedNodeMap attributeMap) throws IOException {
        this.startWriteLine();
        this.writeStartElement(nodeName, attributeMap);
        this.m_writer.write(value);
        this.writeCloseElement(nodeName);
        this.endWriteLine();
    }

    private void addElementNoValue(String nodeName, NamedNodeMap attributeMap) throws IOException {
        this.startWriteLine();
        this.writeElementNoValue(nodeName, attributeMap);
        this.endWriteLine();
    }

    private void writeElementNoValue(String nodeName, NamedNodeMap attributeMap) throws IOException {
        this.m_writer.write(START_ELEMENT);
        this.m_writer.write(nodeName);
        this.writeAttributes(nodeName, attributeMap);
        this.m_writer.write(END_CLOSE_ELEMENT);
    }

    private void openElement(String nodeName, NamedNodeMap attributeMap) throws IOException {
        this.startWriteLine();
        this.writeStartElement(nodeName, attributeMap);
        this.endWriteLine();
        this.incrementTabs();
    }

    private void writeStartElement(String nodeName, NamedNodeMap attributeMap) throws IOException {
        this.m_writer.write(START_ELEMENT);
        this.m_writer.write(nodeName);
        this.writeAttributes(nodeName, attributeMap);
        this.m_writer.write(END_ELEMENT);
    }

    private void writeAttributes(String nodeName, NamedNodeMap attributeMap) throws IOException {
        if (attributeMap != null) {
            boolean attributesOnSameLine = false;
            if (this.m_defaultToAttributesOnSameLine) {
                attributesOnSameLine = true;
            }
            if (this.m_attributesOnSameLine.get(nodeName) != null) {
                attributesOnSameLine = (Boolean)this.m_attributesOnSameLine.get(nodeName);
            }
            if (!attributesOnSameLine) {
                this.m_writer.write(RETURN_CHAR);
                this.incrementTabs();
            }
            ArrayList<Node> attributeList = new ArrayList<Node>();
            if (this.m_attributeOrder.get(nodeName) != null) {
                String[] attributeOrder = (String[])this.m_attributeOrder.get(nodeName);
                for (int i = 0; i < attributeOrder.length; ++i) {
                    Node node = attributeMap.getNamedItem(attributeOrder[i]);
                    attributeList.add(node);
                }
            } else {
                for (int i = 0; i < attributeMap.getLength(); ++i) {
                    Node node = attributeMap.item(i);
                    attributeList.add(node);
                }
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Node node = (Node)attributeList.get(i);
                if (node == null || node.getNodeValue() == null || node.getNodeValue().length() <= 0 && !this.m_writeEmptyValues) continue;
                if (!attributesOnSameLine) {
                    this.m_writer.write(this.m_tabs);
                }
                this.m_writer.write(SPACE);
                this.m_writer.write(node.getNodeName());
                this.m_writer.write(EQUALS);
                this.m_writer.write(QUOTE);
                this.m_writer.write(XmlWriter.safeEncode(node.getNodeValue()));
                this.m_writer.write(QUOTE);
                if (attributesOnSameLine) continue;
                this.m_writer.write(RETURN_CHAR);
            }
            if (!attributesOnSameLine) {
                this.decrementTabs();
                this.m_writer.write(this.m_tabs);
            }
        }
    }

    private void closeElement(String nodeName) throws IOException {
        this.decrementTabs();
        this.startWriteLine();
        this.writeCloseElement(nodeName);
        this.endWriteLine();
    }

    private void writeCloseElement(String nodeName) throws IOException {
        this.m_writer.write(START_CLOSE_ELEMENT);
        this.m_writer.write(nodeName);
        this.m_writer.write(END_ELEMENT);
    }

    public void startWriteLine() throws IOException {
        if (this.m_formatXml) {
            this.m_writer.write(this.m_tabs);
        }
    }

    public void endWriteLine() throws IOException {
        if (this.m_formatXml) {
            this.m_writer.write(RETURN_CHAR);
        }
    }

    private void startXmlDoc() throws IOException {
        this.m_writer.write(HEADER_TEXT);
        this.m_writer.write(RETURN_CHAR);
    }

    private void endXmlDoc() throws IOException {
        this.m_writer.flush();
        this.m_writer.close();
        this.m_outstream.close();
    }

    private void incrementTabs() {
        if (this.m_formatXml) {
            this.m_tabs = this.m_tabs + TAB_CHAR;
        }
    }

    private void decrementTabs() {
        if (this.m_formatXml && this.m_tabs.length() >= TAB_CHAR.length()) {
            this.m_tabs = this.m_tabs.substring(TAB_CHAR.length());
        }
    }

    public static String safeEncode(String str) {
        boolean replacedOne = false;
        int index = 0;
        char[] buf = new char[str.length()];
        str.getChars(0, buf.length, buf, 0);
        for (int i = 0; i < buf.length; ++i) {
            char ch = buf[i];
            if (ch == '\u0000' || ch >= '\u0080' || Character.isISOControl(ch)) {
                buf[index] = 32;
                replacedOne = true;
            }
            ++index;
        }
        if (replacedOne) {
            return new String(buf);
        }
        return str;
    }

    private static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getOsFamily() {
        String osName = XmlWriter.getOsName();
        String familyName = UNKNOWN_FAMILY;
        for (int i = 0; i < OS_FAMILIES.length; ++i) {
            if (!osName.startsWith(OS_FAMILIES[i])) continue;
            familyName = OS_FAMILIES[i];
            break;
        }
        return familyName;
    }
}

