/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.freeform.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.freeform.FreeformPluginException;
import org.codehaus.mojo.freeform.analyser.Analyser;
import org.codehaus.mojo.freeform.project.FreeformProject;
import org.codehaus.mojo.freeform.writer.MavencallWriter;
import org.codehaus.mojo.freeform.writer.ProjectWriter;
import org.codehaus.mojo.freeform.writer.PropertyWriter;

public class GenerateNetbeansProjectMojo
extends AbstractMojo {
    protected ArtifactRepository localRepository;
    protected MavenProject executedProject;
    protected MavenProject project;
    protected String additionalFiles;
    protected String additionalFolders;
    protected String additionalGoals;
    protected String mavenpath;
    protected String outputDirectory;

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setAdditionalFiles(String additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    public void setAdditionalFolders(String additionalFolders) {
        this.additionalFolders = additionalFolders;
    }

    public void setAdditionalGoals(String additionalGoals) {
        this.additionalGoals = additionalGoals;
    }

    public void setExecutedProject(MavenProject executedProject) {
        this.executedProject = executedProject;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setMavenPath(String mavenpath) {
        this.mavenpath = mavenpath;
    }

    public void execute() throws MojoExecutionException {
        try {
            Analyser analyser = this.analyse();
            this.getLog().info((CharSequence)("The project '" + this.project.getName() + "' is analysed."));
            this.addAdditionalTargets(analyser);
            this.addAdditionalActions(analyser);
            this.addAdditionalFiles(analyser);
            this.addAdditionalFolders(analyser);
            File netbeansProjectDirectory = this.createNetbeansProjectDirectory();
            this.writeProjectFile(netbeansProjectDirectory, analyser.getProject());
            this.getLog().info((CharSequence)"The file 'nbproject/project.xml' is created.");
            this.writeMavencallFile(netbeansProjectDirectory, this.outputDirectory != null, analyser.getTargets());
            this.getLog().info((CharSequence)"The file 'nbproject/mavencall.xml' is created.");
            this.writePropertyFile(netbeansProjectDirectory, this.localRepository.getBasedir());
            this.getLog().info((CharSequence)"The file 'nbproject/project.properties' is created.");
        }
        catch (FreeformPluginException fpe) {
            throw new MojoExecutionException(fpe.getMessage(), (Exception)fpe);
        }
    }

    protected void addAdditionalActions(Analyser analyser) throws FreeformPluginException {
        if (this.additionalGoals != null) {
            analyser.addAdditionalActions(this.tokenizeString(this.additionalGoals));
        }
    }

    protected void addAdditionalFiles(Analyser analyser) throws FreeformPluginException {
        if (this.additionalFiles != null) {
            analyser.addAdditionalFiles(this.tokenizeString(this.additionalFiles), this.outputDirectory != null);
        }
    }

    protected void addAdditionalFolders(Analyser analyser) throws FreeformPluginException {
        if (this.additionalFolders != null) {
            analyser.addAdditionalFolders(this.tokenizeString(this.additionalFolders), this.outputDirectory != null);
        }
    }

    protected void addAdditionalTargets(Analyser analyser) throws FreeformPluginException {
        if (this.additionalGoals != null) {
            analyser.addAdditionalTargets(this.tokenizeString(this.additionalGoals));
        }
    }

    protected Analyser analyse() throws FreeformPluginException {
        Analyser analyser = Analyser.getAnalyser(this.project, this.executedProject, this.localRepository, this.getLog(), this.mavenpath);
        analyser.analyseProject(this.outputDirectory != null);
        analyser.analyseTargets(this.outputDirectory != null);
        return analyser;
    }

    protected File createNetbeansProjectDirectory() throws FreeformPluginException {
        File netbeansProjectDirectory = new File(this.outputDirectory == null ? this.project.getBasedir() : new File(this.outputDirectory), "nbproject");
        if (netbeansProjectDirectory.exists() && !netbeansProjectDirectory.isDirectory()) {
            throw new FreeformPluginException("'nbproject' is not a directory");
        }
        if (!netbeansProjectDirectory.exists()) {
            netbeansProjectDirectory.mkdirs();
        }
        return netbeansProjectDirectory;
    }

    protected void writeMavencallFile(File netbeansProjectDirectory, boolean useOutputDirectory, List antTargets) throws FreeformPluginException {
        File mavencallFile = new File(netbeansProjectDirectory, "mavencall.xml");
        MavencallWriter mavencallWriter = new MavencallWriter(antTargets, mavencallFile, this.project, useOutputDirectory, this.getLog());
        mavencallWriter.write();
    }

    protected void writeProjectFile(File netbeansProjectDirectory, FreeformProject freeformProject) throws FreeformPluginException {
        File projectFile = new File(netbeansProjectDirectory, "project.xml");
        ProjectWriter projectWriter = new ProjectWriter(freeformProject, projectFile, this.project, this.getLog());
        projectWriter.write();
    }

    protected void writePropertyFile(File netbeansProjectDirectory, String repositoryBasedir) throws FreeformPluginException {
        File propertyFile = new File(netbeansProjectDirectory, "project.properties");
        PropertyWriter propertyWriter = new PropertyWriter(propertyFile, this.getLog(), this.localRepository, this.project, this.mavenpath);
        propertyWriter.write();
    }

    private List tokenizeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> tokenizedString = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            tokenizedString.add(stringTokenizer.nextToken().trim());
        }
        return tokenizedString.size() != 0 ? tokenizedString : null;
    }
}

