/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamineManifest {
    private Log logger;
    private File jarFile;
    private File manifestFile;
    private boolean netbeansModule;
    private boolean osgiBundle;
    private boolean localized;
    private String specVersion;
    private String implVersion;
    private String module;
    private String moduleDeps;
    private String locBundle;
    private String classpath;
    private boolean publicPackages;
    private boolean populateDependencies = false;
    private List<String> dependencyTokens = Collections.emptyList();
    private boolean friendPackages = false;
    private List<String> friends = Collections.emptyList();
    private List<String> packages = Collections.emptyList();

    ExamineManifest(Log logger) {
        this.logger = logger;
    }

    public void checkFile() throws MojoExecutionException {
        this.resetExamination();
        Manifest mf = null;
        if (this.jarFile != null) {
            JarFile jar = null;
            try {
                jar = new JarFile(this.jarFile);
                mf = jar.getManifest();
            }
            catch (Exception exc) {
                throw new MojoExecutionException(exc.getMessage(), exc);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException io) {
                        throw new MojoExecutionException(io.getMessage(), (Exception)io);
                    }
                }
            }
        }
        if (this.manifestFile != null) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(this.manifestFile);
                mf = new Manifest(stream);
            }
            catch (Exception exc) {
                throw new MojoExecutionException(exc.getMessage(), exc);
            }
            finally {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException io) {
                        throw new MojoExecutionException(io.getMessage(), (Exception)io);
                    }
                }
            }
        }
        if (mf != null) {
            this.processManifest(mf);
        } else {
            File source = this.manifestFile;
            if (source == null) {
                source = this.jarFile;
            }
            this.logger.debug((CharSequence)("Cannot find manifest entries in " + source.getAbsolutePath()));
        }
    }

    void resetExamination() {
        this.setNetbeansModule(false);
        this.setLocalized(false);
        this.setSpecVersion(null);
        this.setImplVersion(null);
        this.setModule(null);
        this.setModuleDeps(null);
        this.setLocBundle(null);
        this.setPublicPackages(false);
        this.setClasspath("");
    }

    void processManifest(Manifest mf) {
        Attributes attrs = mf.getMainAttributes();
        this.setModule(attrs.getValue("OpenIDE-Module"));
        this.setNetbeansModule(this.getModule() != null);
        if (this.isNetbeansModule()) {
            String deps;
            this.setLocBundle(attrs.getValue("OpenIDE-Module-Localizing-Bundle"));
            this.setLocalized(this.getLocBundle() != null);
            this.setSpecVersion(attrs.getValue("OpenIDE-Module-Specification-Version"));
            this.setImplVersion(attrs.getValue("OpenIDE-Module-Implementation-Version"));
            this.setModuleDeps(attrs.getValue("OpenIDE-Module-Module-Dependencies"));
            this.setClasspath(attrs.getValue("Class-Path") == null ? "" : attrs.getValue("Class-Path"));
            String value = attrs.getValue("OpenIDE-Module-Public-Packages");
            String frList = attrs.getValue("OpenIDE-Module-Friends");
            if (value == null || value.trim().equals("-")) {
                this.setPublicPackages(false);
            } else {
                if (frList != null) {
                    this.setPublicPackages(false);
                    String[] friendList = StringUtils.stripAll((String[])StringUtils.split((String)frList, (String)","));
                    this.setFriends(Arrays.asList(friendList));
                } else {
                    this.setPublicPackages(true);
                }
                String[] packageList = StringUtils.stripAll((String[])StringUtils.split((String)value, (String)","));
                this.setPackages(Arrays.asList(packageList));
            }
            if (this.isPopulateDependencies() && (deps = attrs.getValue("OpenIDE-Module-Module-Dependencies")) != null) {
                StringTokenizer tokens = new StringTokenizer(deps, ",");
                ArrayList<String> depList = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    int slash;
                    String tok = tokens.nextToken();
                    int spec = tok.indexOf(">");
                    if (spec <= 0 && (tok.indexOf("=") != -1 || spec != -1)) continue;
                    if (spec > 0) {
                        tok = tok.substring(0, spec - 1);
                    }
                    if ((slash = tok.indexOf("/")) > 0) {
                        tok = tok.substring(0, slash - 1);
                    }
                    depList.add(tok.trim());
                }
                this.setDependencyTokens(depList);
            }
        } else {
            String bndName = attrs.getValue("Bundle-SymbolicName");
            if (bndName != null) {
                this.setOsgiBundle(true);
                this.setModule(bndName);
                this.setSpecVersion(attrs.getValue("Bundle-Version"));
                String exp = attrs.getValue("Export-Package");
                this.setPublicPackages(exp != null);
            } else {
                this.setSpecVersion(attrs.getValue("Specification-Version"));
                this.setImplVersion(attrs.getValue("Implementation-Version"));
                this.setModule(attrs.getValue("Package"));
                this.setPublicPackages(false);
                this.setClasspath("");
                if (this.getModule() == null) {
                    this.setModule(attrs.getValue("Extension-Name"));
                }
            }
        }
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File jarFileLoc) {
        this.jarFile = jarFileLoc;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(File manifestFileLoc) {
        this.manifestFile = manifestFileLoc;
    }

    public void setClasspath(String path) {
        this.classpath = path;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public boolean isNetbeansModule() {
        return this.netbeansModule;
    }

    public void setNetbeansModule(boolean netbeansModule) {
        this.netbeansModule = netbeansModule;
    }

    public boolean isLocalized() {
        return this.localized;
    }

    public void setLocalized(boolean localized) {
        this.localized = localized;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public void setImplVersion(String implVersion) {
        this.implVersion = implVersion;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getModuleDeps() {
        return this.moduleDeps;
    }

    public void setModuleDeps(String moduleDeps) {
        this.moduleDeps = moduleDeps;
    }

    public String getLocBundle() {
        return this.locBundle;
    }

    public void setLocBundle(String locBundle) {
        this.locBundle = locBundle;
    }

    public boolean hasPublicPackages() {
        return this.publicPackages;
    }

    public void setPublicPackages(boolean publicPackages) {
        this.publicPackages = publicPackages;
    }

    public boolean isPopulateDependencies() {
        return this.populateDependencies;
    }

    public void setPopulateDependencies(boolean populateDependencies) {
        this.populateDependencies = populateDependencies;
    }

    public List<String> getDependencyTokens() {
        return this.dependencyTokens;
    }

    public void setDependencyTokens(List<String> dependencyTokens) {
        this.dependencyTokens = dependencyTokens;
    }

    public boolean hasFriendPackages() {
        return this.friendPackages;
    }

    private void setFriends(List<String> fr) {
        this.friendPackages = true;
        this.friends = fr;
    }

    public List<String> getFriends() {
        return this.friends;
    }

    private void setPackages(List<String> pack) {
        this.packages = pack;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public boolean isOsgiBundle() {
        return this.osgiBundle;
    }

    public void setOsgiBundle(boolean osgiBundle) {
        this.osgiBundle = osgiBundle;
    }
}

