/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.servlet.FileSystemServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class FileSystemServer {
    private final Object lock = new Object();
    private boolean starting = false;
    private boolean started = false;
    private boolean finished = false;
    private boolean finishing = false;
    private int boundPort = 0;
    private Exception problem = null;
    private final String name;
    private final FileSystem fileSystem;
    private final int requestedPort;
    private final String settingsServletPath;

    public FileSystemServer(String name, int port, FileSystem fileSystem, String settingsServletPath) {
        this.name = name;
        this.fileSystem = fileSystem;
        this.requestedPort = port;
        this.settingsServletPath = settingsServletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureStarted() throws MojoExecutionException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started || this.starting) {
                return;
            }
            this.starting = true;
            this.started = false;
            this.finished = false;
            this.finishing = false;
        }
        Thread worker = new Thread((Runnable)new Worker(), "FileSystemServer[" + this.name + "]");
        worker.setDaemon(true);
        worker.start();
        try {
            Object object2 = this.lock;
            synchronized (object2) {
                while (this.starting && !this.started && !this.finished && !this.finishing) {
                    this.lock.wait();
                }
                if (this.problem != null) {
                    throw this.problem;
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.lock;
        synchronized (object) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.lock;
        synchronized (object) {
            this.finishing = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinished() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.finished) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            return this.started ? this.boundPort : this.requestedPort;
        }
    }

    public String getUrl() {
        return "http://localhost:" + this.getPort();
    }

    public String getRemoteUrl() throws UnknownHostException {
        return "http://" + InetAddress.getLocalHost().getHostAddress() + ":" + this.getPort();
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Server server = new Server(FileSystemServer.this.requestedPort);
                try {
                    Context root = new Context((HandlerContainer)server, "/", 1);
                    root.addServlet(new ServletHolder((Servlet)new FileSystemServlet(FileSystemServer.this.fileSystem, FileSystemServer.this.settingsServletPath)), "/*");
                    server.start();
                    Object object = FileSystemServer.this.lock;
                    synchronized (object) {
                        FileSystemServer.this.boundPort = 0;
                        Connector[] connectors = server.getConnectors();
                        for (int i = 0; i < connectors.length; ++i) {
                            if (connectors[i].getLocalPort() <= 0) continue;
                            FileSystemServer.this.boundPort = connectors[i].getLocalPort();
                            break;
                        }
                        FileSystemServer.this.starting = false;
                        FileSystemServer.this.started = true;
                        FileSystemServer.this.lock.notifyAll();
                    }
                }
                catch (IOException e) {
                    Object object = FileSystemServer.this.lock;
                    synchronized (object) {
                        FileSystemServer.this.problem = e;
                    }
                    throw e;
                }
                catch (InterruptedException e) {
                    Object object = FileSystemServer.this.lock;
                    synchronized (object) {
                        FileSystemServer.this.problem = e;
                    }
                    throw e;
                }
                catch (Exception e) {
                    Object object = FileSystemServer.this.lock;
                    synchronized (object) {
                        FileSystemServer.this.problem = e;
                    }
                    throw e;
                }
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    while (!FileSystemServer.this.finishing) {
                        try {
                            FileSystemServer.this.lock.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                server.stop();
                server.join();
            }
            catch (IOException iOException) {
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    FileSystemServer.this.started = false;
                    FileSystemServer.this.starting = false;
                    FileSystemServer.this.finishing = false;
                    FileSystemServer.this.finished = true;
                    FileSystemServer.this.boundPort = 0;
                    FileSystemServer.this.lock.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    FileSystemServer.this.started = false;
                    FileSystemServer.this.starting = false;
                    FileSystemServer.this.finishing = false;
                    FileSystemServer.this.finished = true;
                    FileSystemServer.this.boundPort = 0;
                    FileSystemServer.this.lock.notifyAll();
                }
            }
            catch (Exception exception) {
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    FileSystemServer.this.started = false;
                    FileSystemServer.this.starting = false;
                    FileSystemServer.this.finishing = false;
                    FileSystemServer.this.finished = true;
                    FileSystemServer.this.boundPort = 0;
                    FileSystemServer.this.lock.notifyAll();
                }
            }
            finally {
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    FileSystemServer.this.started = false;
                    FileSystemServer.this.starting = false;
                    FileSystemServer.this.finishing = false;
                    FileSystemServer.this.finished = true;
                    FileSystemServer.this.boundPort = 0;
                    FileSystemServer.this.lock.notifyAll();
                }
            }
        }
    }
}

