/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.model.LicenseStore;

@Mojo(name="license-list", requiresProject=false, requiresDirectInvocation=true)
public class LicenseListMojo
extends AbstractLicenseMojo {
    @Parameter(property="extraResolver")
    private String extraResolver;
    @Parameter(property="detail")
    private boolean detail;
    private LicenseStore licenseStore;

    protected void init() throws Exception {
        this.licenseStore = LicenseStore.createLicenseStore(this.getLog(), this.extraResolver);
    }

    public void doAction() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        if (this.isVerbose()) {
            buffer.append("\n\n-------------------------------------------------------------------------------\n");
            buffer.append("                           maven-license-plugin\n");
            buffer.append("-------------------------------------------------------------------------------\n\n");
        }
        buffer.append("Available licenses :\n\n");
        List<String> names = Arrays.asList(this.licenseStore.getLicenseNames());
        int maxLength = 0;
        for (String name : names) {
            if (name.length() <= maxLength) continue;
            maxLength = name.length();
        }
        Collections.sort(names);
        String pattern = " * %1$-" + maxLength + "s : %2$s\n";
        for (String licenseName : names) {
            License license = this.licenseStore.getLicense(licenseName);
            buffer.append(String.format(pattern, licenseName, license.getDescription()));
            if (!this.detail) continue;
            try {
                buffer.append("\n");
                buffer.append(license.getHeaderContent(this.getEncoding()));
                buffer.append("\n\n");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not instanciate license with name " + licenseName + " for reason " + ex.getMessage(), (Exception)ex);
            }
        }
        this.getLog().info((CharSequence)buffer.toString());
    }
}

